/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.report.modules.gui.config.editor.KeyEditor;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.util.ImageUtils;
import org.jfree.util.Configuration;
import org.jfree.util.ResourceBundleSupport;

public abstract class AbstractKeyEditor
extends JComponent
implements KeyEditor {
    public static final String VALID_INPUT_PROPERTY = "validInput";
    private static Icon errorIcon;
    private static Icon emptyIcon;
    private final HierarchicalConfiguration config;
    private final ConfigDescriptionEntry entry;
    private boolean validInput;
    private final JLabel stateLabel;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.config.resources.config-resources");

    public AbstractKeyEditor(HierarchicalConfiguration config, ConfigDescriptionEntry entry) {
        this.setLayout(new BorderLayout());
        this.config = config;
        this.entry = entry;
        this.stateLabel = new JLabel(this.getEmptyIcon());
    }

    protected void deleteValue() {
        this.config.setConfigProperty(this.entry.getKeyName(), null);
    }

    public JComponent getComponent() {
        return this;
    }

    public Configuration getConfig() {
        return this.config;
    }

    protected Icon getEmptyIcon() {
        if (emptyIcon == null) {
            Icon errorIcon = this.getErrorIcon();
            int width = errorIcon.getIconWidth();
            int height = errorIcon.getIconHeight();
            emptyIcon = ImageUtils.createTransparentIcon(width, height);
        }
        return emptyIcon;
    }

    public ConfigDescriptionEntry getEntry() {
        return this.entry;
    }

    protected Icon getErrorIcon() {
        if (errorIcon == null) {
            errorIcon = this.resources.getIcon("default-editor.error-icon");
        }
        return errorIcon;
    }

    public abstract int getLabelWidth();

    public boolean isDefined() {
        return this.config.isLocallyDefined(this.entry.getKeyName());
    }

    public boolean isValidInput() {
        return this.validInput;
    }

    protected String loadValue() {
        return this.config.getConfigProperty(this.entry.getKeyName());
    }

    public abstract void reset();

    protected void setContentPane(JPanel contentPane) {
        this.removeAll();
        this.add((Component)contentPane, "Center");
        this.add((Component)this.stateLabel, "East");
    }

    public abstract void setLabelWidth(int var1);

    protected void setValidInput(boolean validInput) {
        if (this.validInput != validInput) {
            boolean oldValue = this.validInput;
            this.validInput = validInput;
            this.firePropertyChange(VALID_INPUT_PROPERTY, oldValue, validInput);
            if (!this.validInput) {
                this.stateLabel.setIcon(this.getErrorIcon());
            } else {
                this.stateLabel.setIcon(this.getEmptyIcon());
            }
        }
    }

    public abstract void store();

    protected void storeValue(String o) {
        this.config.setConfigProperty(this.entry.getKeyName(), o);
    }
}

