/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public final class ResourceCompareTool {
    private ResourceCompareTool() {
    }

    public static void executeTest(String base, String locale) {
        Object valueBase;
        String key;
        Object value;
        String name;
        ResourceBundle resources = ResourceCompareTool.loadLocale(base, null);
        ResourceBundle compare = ResourceCompareTool.loadLocale(base, locale);
        if (compare == null) {
            System.err.println("The locale " + locale + " is not implemented.");
            System.exit(1);
        }
        Enumeration<String> baseKeys = resources.getKeys();
        Enumeration<String> contentKeys = compare.getKeys();
        Hashtable<String, Object> baseContentTable = new Hashtable<String, Object>();
        Hashtable<String, Object> compContentTable = new Hashtable<String, Object>();
        while (baseKeys.hasMoreElements()) {
            name = baseKeys.nextElement();
            value = resources.getObject(name);
            baseContentTable.put(name, value);
        }
        while (contentKeys.hasMoreElements()) {
            name = contentKeys.nextElement();
            value = compare.getObject(name);
            compContentTable.put(name, value);
        }
        ArrayList<String> notImplemented = new ArrayList<String>();
        ArrayList<String> wrongType = new ArrayList<String>();
        ArrayList<String> invalidKey = new ArrayList<String>();
        Enumeration enumeration = baseContentTable.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            valueBase = baseContentTable.get(key);
            Object valueComp = compContentTable.get(key);
            if (valueComp == null) {
                notImplemented.add(key);
                continue;
            }
            if (valueBase.getClass().isAssignableFrom(valueComp.getClass())) continue;
            wrongType.add(key);
        }
        enumeration = compContentTable.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            valueBase = baseContentTable.get(key);
            if (valueBase != null) continue;
            invalidKey.add(key);
        }
        Collections.sort(wrongType);
        Collections.sort(invalidKey);
        Collections.sort(notImplemented);
        System.out.println("The following keys return values, which are not of the same baseclass as the original key.");
        int i = 0;
        while (i < wrongType.size()) {
            System.out.println(wrongType.get(i));
            ++i;
        }
        System.out.println("---------------------------------------");
        System.out.println("  " + wrongType.size() + " elements listed ");
        System.out.println("---------------------------------------\n\n");
        System.out.println("The following keys are not implemented by the localisation.");
        System.out.println("This does not always indicate an error, if the key does not need to be translated.");
        int i2 = 0;
        while (i2 < notImplemented.size()) {
            System.out.println(notImplemented.get(i2));
            ++i2;
        }
        System.out.println("---------------------------------------");
        System.out.println("  " + notImplemented.size() + " elements listed ");
        System.out.println("---------------------------------------\n\n");
        System.out.println("The following are invalid. These keys are not implemented by the base class.");
        int i3 = 0;
        while (i3 < invalidKey.size()) {
            System.out.println(invalidKey.get(i3));
            ++i3;
        }
        System.out.println("---------------------------------------");
        System.out.println("  " + invalidKey.size() + " elements listed ");
        System.out.println("---------------------------------------\n\n");
        System.exit(0);
    }

    private static ResourceBundle loadLocale(String base, String s) {
        try {
            String className = s != null ? String.valueOf(base) + "_" + s : base;
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (ResourceBundle)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Need locale identifier as argument.");
        }
        ResourceCompareTool.executeTest(args[0], args[1]);
    }
}

