/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jfree.report.event.RepaginationListener;
import org.jfree.report.event.RepaginationState;

public class ReportProgressBar
extends JProgressBar
implements RepaginationListener {
    private int lastPage;
    private int lastPass;
    private int lastMaxRow;
    private MessageFormat pageMessageFormatter;
    private MessageFormat passMessageFormatter;
    private String layoutText;
    private String outputText;
    private ResourceBundle resources = ResourceBundle.getBundle("org.jfree.report.modules.gui.base.resources.jfreereport-resources");

    public ReportProgressBar() {
        this.pageMessageFormatter = new MessageFormat(this.resources.getString("progress-dialog.page-label"));
        this.passMessageFormatter = new MessageFormat(this.resources.getString("progress-dialog.pass-label"));
        this.setOutputText(this.resources.getString("progress-dialog.perform-output"));
        this.setLayoutText(this.resources.getString("progress-dialog.prepare-layout"));
        this.lastPass = -1;
        this.lastMaxRow = -1;
        this.lastPage = -1;
    }

    public String getLayoutText() {
        return this.layoutText;
    }

    public String getOutputText() {
        return this.outputText;
    }

    protected boolean isSameMaxRow(int row) {
        return this.lastMaxRow == row;
    }

    public void repaginationUpdate(RepaginationState state) {
        ScreenUpdateRunnable runnable = new ScreenUpdateRunnable(state.getCurrentRow(), state.getMaxRow(), state.getPage(), state.getPass(), state.isPrepare());
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setLayoutText(String layoutText) {
        if (layoutText == null) {
            throw new NullPointerException("LayoutText must not be null.");
        }
        this.layoutText = layoutText;
    }

    public void setOutputText(String outputText) {
        if (outputText == null) {
            throw new NullPointerException("OutputText must not be null.");
        }
        this.outputText = outputText;
    }

    protected void updatePassMessage(int page, int pass, boolean prepare) {
        if (this.lastPage != page || this.lastPass != pass) {
            StringBuffer message = new StringBuffer();
            Object[] pageparameters = new Object[]{new Integer(page)};
            message.append(this.pageMessageFormatter.format(pageparameters));
            this.lastPage = page;
            this.lastPass = pass;
            if (pass >= 0) {
                Object[] passparameters = new Object[]{new Integer(pass)};
                message.append(this.passMessageFormatter.format(passparameters));
            } else if (prepare) {
                message.append(this.getLayoutText());
            } else {
                message.append(this.getOutputText());
            }
            this.setString(message.toString());
        }
    }

    private class ScreenUpdateRunnable
    implements Runnable {
        private int pass;
        private int page;
        private boolean prepare;
        private int maxRow;
        private int currentRow;

        public ScreenUpdateRunnable(int currentRow, int maxRow, int page, int pass, boolean prepare) {
            this.currentRow = currentRow;
            this.maxRow = maxRow;
            this.page = page;
            this.pass = pass;
            this.prepare = prepare;
        }

        public void run() {
            ReportProgressBar.this.updatePassMessage(this.page, this.pass, this.prepare);
            boolean maxRowSame = ReportProgressBar.this.isSameMaxRow(this.maxRow);
            if (!maxRowSame) {
                ReportProgressBar.this.setMaximum(this.maxRow);
            }
            ReportProgressBar.this.setValue(this.currentRow);
        }
    }
}

