/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.ExportPlugin;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.ExportTaskListener;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.PreviewProxyBase;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.base.Skin;
import org.jfree.report.modules.gui.base.SkinLoader;
import org.jfree.report.util.WorkerPool;

public abstract class AbstractExportPlugin
implements ExportPlugin {
    private PreviewProxyBase base;
    private PreviewProxy proxy;
    private WorkerPool worker;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean enabled;
    private Skin skin = SkinLoader.loadSkin();

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(property, l);
    }

    protected ReportProgressDialog createProgressDialog() {
        if (this.proxy instanceof Frame) {
            return new ReportProgressDialog((Frame)((Object)this.proxy));
        }
        if (this.proxy instanceof Dialog) {
            return new ReportProgressDialog((Dialog)((Object)this.proxy));
        }
        if (this.proxy != null) {
            PreviewProxyBase base = this.proxy.getBase();
            Window w = PreviewProxyBase.getWindowAncestor(base);
            if (w instanceof Frame) {
                return new ReportProgressDialog((Frame)w);
            }
            if (w instanceof Dialog) {
                return new ReportProgressDialog((Dialog)w);
            }
        }
        return new ReportProgressDialog();
    }

    public void defineWorkerPool(WorkerPool worker) {
        this.worker = worker;
    }

    public void delegateTask(Runnable runnable) {
        if (this.worker != null) {
            WorkerPool workerPool = this.worker;
            synchronized (workerPool) {
                this.worker.isWorkerAvailable();
                this.worker.getWorkerForWorkload(runnable);
            }
        } else {
            runnable.run();
        }
    }

    public abstract KeyStroke getAcceleratorKey();

    public PreviewProxyBase getBase() {
        return this.base;
    }

    public abstract String getDisplayName();

    public String getFailureDescription() {
        return String.valueOf(this.getDisplayName()) + " failed on export.";
    }

    public abstract Icon getLargeIcon();

    public abstract Integer getMnemonicKey();

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public PreviewProxy getProxy() {
        return this.proxy;
    }

    public abstract String getShortDescription();

    protected Skin getSkin() {
        return this.skin;
    }

    public abstract Icon getSmallIcon();

    protected boolean handleExportResult(ExportTask task) {
        if (!task.isTaskDone()) {
            this.updateStatusText("Exporting ...");
            return true;
        }
        if (task.getReturnValue() == 0) {
            this.updateStatusText("Export was successful.");
            return true;
        }
        if (task.getReturnValue() == 2) {
            this.updateStatusText("Export was aborted.");
            return false;
        }
        if (task.getException() != null) {
            this.updateStatusText("Export failed: " + task.getException().getLocalizedMessage());
        } else {
            this.updateStatusText("Export failed: " + this.getFailureDescription());
        }
        return false;
    }

    protected boolean handleExportResult(boolean result) {
        if (!this.isControlPlugin() && !result) {
            this.updateStatusText("Export failed: " + this.getFailureDescription());
        }
        return result;
    }

    public void init(PreviewProxy proxy) {
        if (proxy == null) {
            throw new NullPointerException("Proxy must not be null.");
        }
        if (proxy.getBase() == null) {
            throw new NullPointerException("Proxy must be initialized.");
        }
        this.base = proxy.getBase();
        this.proxy = proxy;
    }

    public boolean isAddToToolbar() {
        return false;
    }

    public boolean isControlPlugin() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSeparated() {
        return false;
    }

    public abstract boolean performExport(JFreeReport var1);

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.propertyChangeSupport.firePropertyChange("enabled", oldEnabled, enabled);
    }

    protected void updateStatusText(String text) {
        this.getBase().setStatusText(text);
    }

    protected class DefaultExportTaskListener
    implements ExportTaskListener {
        public void taskAborted(ExportTask task) {
            AbstractExportPlugin.this.handleExportResult(task);
        }

        public void taskDone(ExportTask task) {
            AbstractExportPlugin.this.handleExportResult(task);
        }

        public void taskFailed(ExportTask task) {
            AbstractExportPlugin.this.handleExportResult(task);
        }

        public void taskWaiting(ExportTask task) {
        }
    }
}

