/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.layout;

import java.awt.geom.Dimension2D;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.layout.BandLayoutManager;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.report.util.geom.StrictPoint;
import org.jfree.util.Log;

public abstract class AbstractBandLayoutManager
implements BandLayoutManager {
    public static final long RELATIVE_CORRECTION_FACTOR = StrictGeomUtility.toInternalValue(100.0);

    protected AbstractBandLayoutManager() {
    }

    public static long alignDown(long value, long boundary) {
        if (boundary == 0L) {
            return value;
        }
        if (value == 0L) {
            return 0L;
        }
        return value / boundary * boundary;
    }

    public static long alignUp(long value, long boundary) {
        if (boundary == 0L) {
            return value;
        }
        if (value == 0L) {
            return 0L;
        }
        long flooredVal = (long)Math.ceil((double)value / (double)boundary);
        return flooredVal * boundary;
    }

    protected static StrictDimension correctDimension(StrictDimension dim, StrictDimension base, StrictDimension retval, LayoutSupport support) {
        long newWidth = dim.getWidth();
        if (dim.getWidth() < 0L) {
            newWidth = dim.getWidth() * base.getWidth() / -RELATIVE_CORRECTION_FACTOR;
        }
        long newHeight = dim.getHeight();
        if (dim.getHeight() < 0L) {
            newHeight = dim.getHeight() * base.getHeight() / -RELATIVE_CORRECTION_FACTOR;
        }
        if (retval == null) {
            return new StrictDimension(AbstractBandLayoutManager.alignUp(newWidth, support.getInternalHorizontalAlignmentBorder()), AbstractBandLayoutManager.alignUp(newHeight, support.getInternalVerticalAlignmentBorder()));
        }
        retval.setSize(AbstractBandLayoutManager.alignUp(newWidth, support.getInternalHorizontalAlignmentBorder()), AbstractBandLayoutManager.alignUp(newHeight, support.getInternalVerticalAlignmentBorder()));
        return retval;
    }

    protected static StrictPoint correctPoint(StrictPoint dim, StrictDimension base, StrictPoint retval, LayoutSupport support) {
        long x = dim.getX();
        long y = dim.getY();
        if (x < 0L) {
            x = dim.getX() * base.getWidth() / -RELATIVE_CORRECTION_FACTOR;
        }
        if (y < 0L) {
            y = dim.getY() * base.getHeight() / -RELATIVE_CORRECTION_FACTOR;
        }
        if (retval == null) {
            return new StrictPoint(AbstractBandLayoutManager.alignDown(x, support.getInternalHorizontalAlignmentBorder()), AbstractBandLayoutManager.alignDown(y, support.getInternalVerticalAlignmentBorder()));
        }
        retval.setLocation(AbstractBandLayoutManager.alignDown(x, support.getInternalHorizontalAlignmentBorder()), AbstractBandLayoutManager.alignDown(y, support.getInternalVerticalAlignmentBorder()));
        return retval;
    }

    protected static long correctRelativeValue(long dim, long base) {
        if (dim < 0L) {
            return dim * base / -RELATIVE_CORRECTION_FACTOR;
        }
        return dim;
    }

    protected ElementLayoutInformation createLayoutInfoForDynamics(Element e, StrictDimension parentDim, StrictDimension maxUsableSize, LayoutSupport support) {
        Dimension2D eMaxDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMaxDim.getWidth(), eMaxDim.getHeight()), parentDim, null, support);
        Dimension2D eMinDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
        StrictDimension minSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMinDim.getWidth(), eMinDim.getHeight()), parentDim, null, support);
        Dimension2D ePrefDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
        StrictDimension prefSize = ePrefDim != null ? AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(ePrefDim.getWidth(), ePrefDim.getHeight()), parentDim, null, support) : null;
        maxSize.setSize(Math.min(maxUsableSize.getWidth(), maxSize.getWidth()), maxUsableSize.getHeight());
        ElementLayoutInformation eli = new ElementLayoutInformation(new StrictPoint(), minSize, maxSize, prefSize);
        return eli;
    }

    protected ElementLayoutInformation createLayoutInformationForMinimumSize(Element e, StrictDimension containerBounds, StrictDimension maxUsableSize, LayoutSupport support) {
        Dimension2D eMinDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
        StrictDimension minSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMinDim.getWidth(), eMinDim.getHeight()), containerBounds, null, support);
        Dimension2D eMaxDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMaxDim.getWidth(), eMaxDim.getHeight()), containerBounds, null, support);
        long maxW = Math.min(maxSize.getWidth(), maxUsableSize.getWidth());
        long maxH = Math.min(maxSize.getHeight(), maxUsableSize.getHeight());
        maxSize.setSize(maxW, maxH);
        return new ElementLayoutInformation(new StrictPoint(), minSize, maxSize);
    }

    protected ElementLayoutInformation createLayoutInformationForPreferredSize(Element e, StrictDimension containerDims, StrictDimension maxUsableSize, LayoutSupport support) {
        StrictDimension prefSize;
        Dimension2D eMinDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
        StrictDimension minSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMinDim.getWidth(), eMinDim.getHeight()), containerDims, null, support);
        Dimension2D eMaxDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMaxDim.getWidth(), eMaxDim.getHeight()), containerDims, null, support);
        long height = 0L;
        long width = 0L;
        Dimension2D ePrefDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
        if (ePrefDim != null) {
            prefSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(ePrefDim.getWidth(), ePrefDim.getHeight()), containerDims, null, support);
            height = AbstractBandLayoutManager.alignUp(AbstractBandLayoutManager.correctRelativeValue(prefSize.getHeight(), containerDims.getHeight()), support.getInternalVerticalAlignmentBorder());
            width = AbstractBandLayoutManager.alignUp(AbstractBandLayoutManager.correctRelativeValue(prefSize.getWidth(), containerDims.getWidth()), support.getInternalHorizontalAlignmentBorder());
        } else {
            prefSize = null;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        long maxW = Math.min(maxSize.getWidth(), maxUsableSize.getWidth());
        long maxH = Math.min(maxSize.getHeight(), maxUsableSize.getHeight());
        maxSize.setSize(maxW, maxH);
        minSize.setSize(width, height);
        return new ElementLayoutInformation(new StrictPoint(), minSize, maxSize, prefSize);
    }

    public abstract void doLayout(Band var1, LayoutSupport var2);

    protected StrictDimension getElementContentBounds(StrictDimension bounds, Element e, StrictDimension containerBounds, StrictDimension maxUsablesize, LayoutSupport support) {
        ContentFactory contentFactory = support.getContentFactory();
        if (!contentFactory.canHandleContent(e.getContentType())) {
            return bounds;
        }
        ElementLayoutInformation eli = this.createLayoutInfoForDynamics(e, containerBounds, maxUsablesize, support);
        StrictDimension minSize = eli.getMinimumSize();
        try {
            Content content = contentFactory.createContentForElement(e, eli, support);
            if (content == null) {
                bounds.setSize(0L, 0L);
                return bounds;
            }
            StrictBounds contentBounds = content.getMinimumContentSize();
            if (contentBounds == null) {
                bounds.setSize(0L, 0L);
                return bounds;
            }
            bounds.setSize(Math.max(minSize.getWidth(), contentBounds.getWidth()), Math.max(minSize.getHeight(), contentBounds.getHeight()));
            return bounds;
        }
        catch (Exception ex) {
            Log.info((Object)"Exception while layouting dynamic content: ", (Exception)ex);
            bounds.setSize(Math.max(minSize.getWidth(), bounds.getWidth()), Math.max(minSize.getHeight(), bounds.getHeight()));
            return bounds;
        }
    }

    protected boolean isElementStaticHeight(Element e) {
        Dimension2D size = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
        if (size.getHeight() < 0.0) {
            return false;
        }
        size = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        if (size.getHeight() < 0.0) {
            return false;
        }
        size = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
        return size == null || !(size.getHeight() < 0.0);
    }

    protected boolean isElementStaticWidth(Element e) {
        Dimension2D size = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
        if (size.getWidth() < 0.0) {
            return false;
        }
        size = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        if (size.getWidth() < 0.0) {
            return false;
        }
        size = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
        return size == null || !(size.getWidth() < 0.0);
    }

    public abstract StrictDimension minimumLayoutSize(Band var1, StrictDimension var2, StrictDimension var3, LayoutSupport var4);

    public abstract StrictDimension preferredLayoutSize(Band var1, StrictDimension var2, StrictDimension var3, LayoutSupport var4);
}

