/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.util.ArrayList;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.Function;

public final class FunctionUtilities {
    private FunctionUtilities() {
    }

    public static Element[] findAllElements(Band band, String element) {
        if (element == null) {
            throw new NullPointerException("Element name must not be null");
        }
        ArrayList<Band> collector = new ArrayList<Band>();
        if (band.getName().equals(element)) {
            collector.add(band);
        }
        FunctionUtilities.performFindElement(band, element, collector);
        return collector.toArray(new Element[collector.size()]);
    }

    public static Element findElement(Band band, String element) {
        if (element == null) {
            throw new NullPointerException("Element name must not be null");
        }
        Element[] elements = band.getElementArray();
        if (band.getName().equals(element)) {
            return band;
        }
        int i = 0;
        while (i < elements.length) {
            Element retval;
            Element e = elements[i];
            if (e.getName().equals(element)) {
                return e;
            }
            if (e instanceof Band && (retval = FunctionUtilities.findElement((Band)e, element)) != null) {
                return retval;
            }
            ++i;
        }
        return null;
    }

    public static Group getCurrentGroup(ReportEvent event) {
        if (event == null) {
            throw new NullPointerException("ReportEvent is null");
        }
        return event.getReport().getGroup(event.getState().getCurrentGroupIndex());
    }

    public static boolean isDefinedGroup(String groupName, ReportEvent event) {
        if (groupName == null) {
            return false;
        }
        Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
        return groupName.equals(group.getName());
    }

    public static boolean isDefinedPrepareRunLevel(Function f, ReportEvent event) {
        if (f == null) {
            throw new NullPointerException("Function is null");
        }
        if (event == null) {
            throw new NullPointerException("ReportEvent is null");
        }
        if (!event.getState().isPrepareRun()) {
            return false;
        }
        return event.getState().getLevel() == f.getDependencyLevel();
    }

    public static boolean isLayoutLevel(ReportEvent event) {
        if (event == null) {
            throw new NullPointerException("ReportEvent is null");
        }
        return event.getState().getLevel() < 0;
    }

    private static void performFindElement(Band band, String element, ArrayList collector) {
        Element[] elements = band.getElementArray();
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.getName().equals(element)) {
                collector.add(e);
            }
            if (e instanceof Band) {
                FunctionUtilities.performFindElement((Band)e, element, collector);
            }
            ++i;
        }
    }
}

