/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.report.function.AbstractExpression;

public class AverageExpression
extends AbstractExpression
implements Serializable {
    private ArrayList fieldList = new ArrayList();

    public Object clone() throws CloneNotSupportedException {
        AverageExpression ae = (AverageExpression)super.clone();
        ae.fieldList = (ArrayList)this.fieldList.clone();
        return ae;
    }

    private Number[] collectValues() {
        Number[] retval = new Number[this.fieldList.size()];
        int i = 0;
        while (i < this.fieldList.size()) {
            String field = (String)this.fieldList.get(i);
            retval[i] = (Number)this.getDataRow().get(field);
            ++i;
        }
        return retval;
    }

    public String[] getField() {
        return this.fieldList.toArray(new String[this.fieldList.size()]);
    }

    public String getField(int idx) {
        return (String)this.fieldList.get(idx);
    }

    public Object getValue() {
        Number[] values = this.collectValues();
        BigDecimal total = new BigDecimal(0.0);
        int count = 0;
        int i = 0;
        while (i < values.length) {
            Number n = values[i];
            if (n != null) {
                total = total.add(new BigDecimal(n.toString()));
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            return total.divide(new BigDecimal((double)count), 4);
        }
        return new BigDecimal(0.0);
    }

    public void setField(int idx, String object) {
        if (this.fieldList.size() == idx) {
            this.fieldList.add(object);
        } else {
            this.fieldList.set(idx, object);
        }
    }

    public void setField(String[] fields) {
        this.fieldList.clear();
        this.fieldList.addAll(Arrays.asList(fields));
    }
}

