/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter.templates;

import java.util.MissingResourceException;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DataRowDataSource;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.report.filter.ResourceFileFilter;
import org.jfree.report.filter.StringFilter;
import org.jfree.report.filter.templates.AbstractTemplate;

public class ResourceFieldTemplate
extends AbstractTemplate
implements ReportConnectable {
    private DataRowDataSource dataRowDataSource = new DataRowDataSource();
    private StringFilter stringFilter;
    private ResourceFileFilter resourceFilter = new ResourceFileFilter();

    public ResourceFieldTemplate() {
        this.resourceFilter.setDataSource(this.dataRowDataSource);
        this.stringFilter = new StringFilter();
        this.stringFilter.setDataSource(this.resourceFilter);
    }

    public Object clone() throws CloneNotSupportedException {
        ResourceFieldTemplate template = (ResourceFieldTemplate)super.clone();
        template.stringFilter = (StringFilter)this.stringFilter.clone();
        template.resourceFilter = (ResourceFileFilter)template.stringFilter.getDataSource();
        template.dataRowDataSource = (DataRowDataSource)template.resourceFilter.getDataSource();
        return template;
    }

    protected DataRowDataSource getDataRowDataSource() {
        return this.dataRowDataSource;
    }

    public String getField() {
        return this.dataRowDataSource.getDataSourceColumnName();
    }

    public String getNullValue() {
        return this.stringFilter.getNullValue();
    }

    public String getResourceIdentifier() {
        return this.resourceFilter.getResourceIdentifier();
    }

    public Object getValue() {
        return this.stringFilter.getValue();
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        this.getDataRowDataSource().registerReportDefinition(reportDefinition);
        this.resourceFilter.registerReportDefinition(reportDefinition);
    }

    public void setField(String field) {
        this.dataRowDataSource.setDataSourceColumnName(field);
    }

    public void setNullValue(String nullValue) {
        this.stringFilter.setNullValue(nullValue);
    }

    public void setResourceIdentifier(String resourceClassName) throws MissingResourceException {
        this.resourceFilter.setResourceIdentifier(resourceClassName);
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        this.getDataRowDataSource().unregisterReportDefinition(reportDefinition);
        this.resourceFilter.unregisterReportDefinition(reportDefinition);
    }
}

