/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ShapeElement;
import org.jfree.report.content.ShapeTransform;
import org.jfree.report.elementfactory.ShapeElementFactory;
import org.jfree.report.filter.StaticDataSource;
import org.jfree.ui.FloatDimension;
import org.jfree.util.Log;

public class StaticShapeElementFactory
extends ShapeElementFactory {
    private Shape shape;

    public Element createElement() {
        ShapeElement e = new ShapeElement();
        this.applyElementName(e);
        this.applyStyle(e.getStyle());
        e.setDataSource(new StaticDataSource(this.getShape()));
        return e;
    }

    public static ShapeElement createHorizontalLine(String name, Color paint, Stroke stroke, double y1) {
        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, (float)y1, -100.0f, 0.0f);
        ShapeElement element = StaticShapeElementFactory.createShapeElement(name, bounds, paint, stroke, new Line2D.Float(0.0f, 0.0f, 100.0f, 0.0f), true, false, true);
        element.setDynamicContent(false);
        return element;
    }

    public static ShapeElement createLineShapeElement(String name, Color paint, Stroke stroke, Line2D shape) {
        if (shape.getX1() == shape.getX2() && shape.getY1() == shape.getY2()) {
            Log.info((Object)"The use of Line(x1, y1, x1, y1) to create a scaled horizontal line is deprecated.\nUse a Horizontal-Line element instead.");
            return StaticShapeElementFactory.createHorizontalLine(name, paint, stroke, shape.getY1());
        }
        Rectangle2D bounds = shape.getBounds2D();
        if (bounds.getX() < 0.0) {
            throw new IllegalArgumentException("Line coordinates must not be negative.");
        }
        if (bounds.getY() < 0.0) {
            throw new IllegalArgumentException("Line coordinates must not be negative.");
        }
        shape.setLine(shape.getX1() - bounds.getX(), shape.getY1() - bounds.getY(), shape.getX2() - bounds.getX(), shape.getY2() - bounds.getY());
        return StaticShapeElementFactory.createShapeElement(name, bounds, paint, stroke, shape, true, false, true);
    }

    public static ShapeElement createRectangleShapeElement(String name, Color paint, Stroke stroke, Rectangle2D shape, boolean shouldDraw, boolean shouldFill) {
        if (shape.getX() < 0.0 || shape.getY() < 0.0 || shape.getWidth() < 0.0 || shape.getHeight() < 0.0) {
            return StaticShapeElementFactory.createShapeElement(name, shape, paint, stroke, new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f), shouldDraw, shouldFill, true);
        }
        Rectangle2D rect = (Rectangle2D)shape.clone();
        rect.setRect(0.0, 0.0, rect.getWidth(), rect.getHeight());
        return StaticShapeElementFactory.createShapeElement(name, shape, paint, stroke, rect, shouldDraw, shouldFill, false);
    }

    public static ShapeElement createShapeElement(String name, Color paint, Stroke stroke, Shape shape, boolean shouldDraw, boolean shouldFill) {
        Rectangle2D shapeBounds = shape.getBounds2D();
        if (shapeBounds.getX() == 0.0 && shapeBounds.getY() == 0.0) {
            return StaticShapeElementFactory.createShapeElement(name, shapeBounds, paint, stroke, shape, shouldDraw, shouldFill, true);
        }
        Shape transformedShape = ShapeTransform.translateShape(shape, -shapeBounds.getX(), -shapeBounds.getY());
        return StaticShapeElementFactory.createShapeElement(name, shapeBounds, paint, stroke, transformedShape, shouldDraw, shouldFill, true);
    }

    public static ShapeElement createShapeElement(String name, Rectangle2D bounds, Color paint, Stroke stroke, Shape shape, boolean shouldDraw, boolean shouldFill, boolean shouldScale) {
        return StaticShapeElementFactory.createShapeElement(name, bounds, paint, stroke, shape, shouldDraw, shouldFill, shouldScale, false);
    }

    public static ShapeElement createShapeElement(String name, Rectangle2D bounds, Color paint, Stroke stroke, Shape shape, boolean shouldDraw, boolean shouldFill, boolean shouldScale, boolean keepAspectRatio) {
        StaticShapeElementFactory factory = new StaticShapeElementFactory();
        factory.setName(name);
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setColor(paint);
        factory.setKeepAspectRatio(new Boolean(keepAspectRatio));
        factory.setScale(new Boolean(shouldScale));
        factory.setShouldDraw(new Boolean(shouldDraw));
        factory.setShouldFill(new Boolean(shouldFill));
        factory.setShape(shape);
        factory.setStroke(stroke);
        return (ShapeElement)factory.createElement();
    }

    public static ShapeElement createVerticalLine(String name, Color paint, Stroke stroke, double x) {
        Rectangle2D.Float bounds = new Rectangle2D.Float((float)x, 0.0f, 0.0f, -100.0f);
        ShapeElement element = StaticShapeElementFactory.createShapeElement(name, bounds, paint, stroke, new Line2D.Float(0.0f, 0.0f, 0.0f, 100.0f), true, false, true);
        element.setDynamicContent(false);
        return element;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new NullPointerException();
        }
        this.shape = shape;
    }
}

