/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ImageElement;
import org.jfree.report.elementfactory.ImageElementFactory;
import org.jfree.report.filter.templates.ImageFieldTemplate;
import org.jfree.ui.FloatDimension;

public class ImageFieldElementFactory
extends ImageElementFactory {
    private String fieldname;

    public Element createElement() {
        if (this.getFieldname() == null) {
            throw new IllegalStateException("Fieldname is not set.");
        }
        ImageFieldTemplate template = new ImageFieldTemplate();
        template.setField(this.getFieldname());
        ImageElement element = new ImageElement();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setDataSource(template);
        return element;
    }

    public static ImageElement createImageDataRowElement(String name, Rectangle2D bounds, String field) {
        return ImageFieldElementFactory.createImageDataRowElement(name, bounds, field, true);
    }

    public static ImageElement createImageDataRowElement(String name, Rectangle2D bounds, String field, boolean scale) {
        return ImageFieldElementFactory.createImageDataRowElement(name, bounds, field, scale, false);
    }

    public static ImageElement createImageDataRowElement(String name, Rectangle2D bounds, String field, boolean scale, boolean keepAspectRatio) {
        ImageFieldElementFactory factory = new ImageFieldElementFactory();
        factory.setName(name);
        factory.setName(name);
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setScale(new Boolean(scale));
        factory.setKeepAspectRatio(new Boolean(keepAspectRatio));
        factory.setFieldname(field);
        return (ImageElement)factory.createElement();
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }
}

