/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.ui.FloatDimension;

public strictfp final class ShapeTransform {
    public static final int LEFT = 1;
    public static final int H_CENTER = 2;
    public static final int RIGHT = 4;
    public static final int BELOW = 16;
    public static final int V_CENTER = 32;
    public static final int ABOVE = 64;
    private static final double DELTA = 1.0E-6;
    public static final int INSIDE = 34;
    public static final int OUTSIDE = 85;

    private ShapeTransform() {
    }

    public static Point2D[] getClipped(double x1, double y1, double x2, double y2, double xmin, double xmax, double ymin, double ymax) {
        int mask1 = 0;
        int mask2 = 0;
        mask1 = x1 < xmin ? (mask1 |= 1) : (x1 > xmax ? (mask1 |= 4) : (mask1 |= 2));
        mask1 = y1 < ymin ? (mask1 |= 0x10) : (y1 > ymax ? (mask1 |= 0x40) : (mask1 |= 0x20));
        mask2 = x2 < xmin ? (mask2 |= 1) : (x2 > xmax ? (mask2 |= 4) : (mask2 |= 2));
        mask2 = y2 < ymin ? (mask2 |= 0x10) : (y2 > ymax ? (mask2 |= 0x40) : (mask2 |= 0x20));
        int mask = mask1 | mask2;
        if ((mask & 0x55) == 0) {
            Point2D[] ret = new Point2D[]{new Point2D.Double(x1, y1), new Point2D.Double(x2, y2)};
            return ret;
        }
        if ((mask & 3) == 0 || (mask & 6) == 0 || (mask & 0x30) == 0 || (mask & 0x60) == 0) {
            return null;
        }
        return ShapeTransform.getClipped(x1, y1, mask1, x2, y2, mask2, xmin, xmax, ymin, ymax);
    }

    protected static Point2D[] getClipped(double x1, double y1, int mask1, double x2, double y2, int mask2, double xmin, double xmax, double ymin, double ymax) {
        Point2D p;
        int mask = mask1 ^ mask2;
        Point2D p1 = null;
        if (mask1 == 34) {
            p1 = new Point2D.Double(x1, y1);
            if (mask == 0) {
                Point2D[] ret = new Point2D[]{p1, new Point2D.Double(x2, y2)};
                return ret;
            }
        } else if (mask2 == 34) {
            p1 = new Point2D.Double(x2, y2);
        }
        if ((mask & 1) != 0 && (p = ShapeTransform.intersect(x1, y1, x2, y2, xmin, ymin, xmin, ymax)) != null) {
            if (p1 == null) {
                p1 = p;
            } else {
                Point2D[] ret = new Point2D[]{p1, p};
                return ret;
            }
        }
        if ((mask & 4) != 0 && (p = ShapeTransform.intersect(x1, y1, x2, y2, xmax, ymin, xmax, ymax)) != null) {
            if (p1 == null) {
                p1 = p;
            } else {
                Point2D[] ret = new Point2D[]{p1, p};
                return ret;
            }
        }
        if (mask1 == 17 || mask1 == 20) {
            if ((mask & 0x40) != 0 && (p = ShapeTransform.intersect(x1, y1, x2, y2, xmin, ymax, xmax, ymax)) != null) {
                if (p1 == null) {
                    p1 = p;
                } else {
                    Point2D[] ret = new Point2D[]{p1, p};
                    return ret;
                }
            }
            if ((mask & 0x10) != 0 && (p = ShapeTransform.intersect(x1, y1, x2, y2, xmin, ymin, xmax, ymin)) != null && p1 != null) {
                Point2D[] ret = new Point2D[]{p1, p};
                return ret;
            }
        } else {
            if ((mask & 0x10) != 0 && (p = ShapeTransform.intersect(x1, y1, x2, y2, xmin, ymin, xmax, ymin)) != null) {
                if (p1 == null) {
                    p1 = p;
                } else {
                    Point2D[] ret = new Point2D[]{p1, p};
                    return ret;
                }
            }
            if ((mask & 0x40) != 0 && (p = ShapeTransform.intersect(x1, y1, x2, y2, xmin, ymax, xmax, ymax)) != null && p1 != null) {
                Point2D[] ret = new Point2D[]{p1, p};
                return ret;
            }
        }
        return null;
    }

    private static Line2D getNormalizedLine(Line2D line) {
        Line2D lineClone = (Line2D)line.clone();
        Point2D p1 = line.getP1();
        Point2D p2 = line.getP2();
        if (p1.getX() < p2.getX()) {
            return lineClone;
        }
        if (p1.getX() > p2.getX()) {
            lineClone.setLine(p2, p1);
            return lineClone;
        }
        if (p1.getY() < p2.getY()) {
            return lineClone;
        }
        lineClone.setLine(p2, p1);
        return lineClone;
    }

    private static Point2D intersect(double x11, double y11, double x12, double y12, double x21, double y21, double x22, double y22) {
        double mu;
        double dx2 = x22 - x21;
        double dy1 = y12 - y11;
        double dy2 = y22 - y21;
        double dx1 = x12 - x11;
        double det = dx2 * dy1 - dy2 * dx1;
        if (det != 0.0 && (mu = ((x11 - x21) * dy1 - (y11 - y21) * dx1) / det) >= 0.0 && mu <= 1.0) {
            Point2D.Double p = new Point2D.Double(x21 + mu * dx2, y21 + mu * dy2);
            return p;
        }
        return null;
    }

    public static Shape performCliping(Shape s, Rectangle2D bounds) {
        if (s instanceof Line2D) {
            Line2D line = (Line2D)s;
            Point2D[] clipped = ShapeTransform.getClipped(line.getX1(), line.getY1(), line.getX2(), line.getY2(), -1.0E-6, 1.0E-6 + bounds.getWidth(), -1.0E-6, 1.0E-6 + bounds.getHeight());
            if (clipped == null) {
                return new GeneralPath();
            }
            return new Line2D.Float(clipped[0], clipped[1]);
        }
        Rectangle2D boundsCorrected = bounds.getBounds2D();
        boundsCorrected.setRect(-1.0E-6, -1.0E-6, 1.0E-6 + boundsCorrected.getWidth(), 1.0E-6 + boundsCorrected.getHeight());
        Area a = new Area(boundsCorrected);
        if (a.isEmpty()) {
            return new GeneralPath();
        }
        Area clipArea = new Area(s);
        a.intersect(clipArea);
        return a;
    }

    private static Shape performDefaultTransformation(Shape shape, double scaleX, double scaleY) {
        Rectangle2D bounds = shape.getBounds2D();
        AffineTransform af = AffineTransform.getTranslateInstance(0.0 - bounds.getX(), 0.0 - bounds.getY());
        Shape s = af.createTransformedShape(shape);
        af = AffineTransform.getScaleInstance(scaleX, scaleY);
        s = af.createTransformedShape(s);
        af = AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY());
        return af.createTransformedShape(s);
    }

    public static Line2D resizeLine(Line2D line, double width, double height) {
        Line2D newLine = ShapeTransform.getNormalizedLine(line);
        Point2D p1 = newLine.getP1();
        Point2D p2 = newLine.getP2();
        double normPointX = p1.getX() - p2.getX();
        double normPointY = p1.getY() - p2.getY();
        double scaleX = normPointX == 0.0 ? 1.0 : width / Math.abs(normPointX);
        double scaleY = normPointY == 0.0 ? 1.0 : height / Math.abs(normPointY);
        p2.setLocation((p2.getX() - p1.getX()) * scaleX + p1.getX(), (p2.getY() - p1.getY()) * scaleY + p1.getY());
        newLine.setLine(p1, p2);
        return newLine;
    }

    public static Shape resizeRect(RectangularShape rectangularShape, double width, double height) {
        RectangularShape retval = (RectangularShape)rectangularShape.clone();
        retval.setFrame(retval.getX(), retval.getY(), width, height);
        return retval;
    }

    public static Shape resizeShape(Shape s, float width, float height) {
        if (s instanceof Line2D) {
            return ShapeTransform.resizeLine((Line2D)s, width, height);
        }
        if (s instanceof RectangularShape) {
            return ShapeTransform.resizeRect((RectangularShape)s, width, height);
        }
        return ShapeTransform.transformShape(s, true, false, (Dimension2D)new FloatDimension(width, height));
    }

    public static Shape transformShape(Shape s, boolean scale, boolean keepAR, Dimension2D dim) {
        if (scale) {
            Rectangle2D boundsShape = s.getBounds2D();
            double w = boundsShape.getWidth();
            double h = boundsShape.getHeight();
            double scaleX = 1.0;
            double scaleY = 1.0;
            if (w != 0.0) {
                scaleX = dim.getWidth() / w;
            }
            if (h != 0.0) {
                scaleY = dim.getHeight() / h;
            }
            if (scaleX != 1.0 || scaleY != 1.0) {
                if (s instanceof RectangularShape) {
                    return ShapeTransform.resizeRect((RectangularShape)s, w * scaleX, h * scaleY);
                }
                if (s instanceof Line2D) {
                    return ShapeTransform.resizeLine((Line2D)s, w * scaleX, h * scaleY);
                }
                if (keepAR) {
                    double scaleFact = Math.min(scaleX, scaleY);
                    return ShapeTransform.performDefaultTransformation(s, scaleFact, scaleFact);
                }
                return ShapeTransform.performDefaultTransformation(s, scaleX, scaleY);
            }
        }
        return s;
    }

    public static Shape translateShape(Shape s, double x, double y) {
        if (s instanceof RectangularShape) {
            RectangularShape rect = (RectangularShape)s;
            RectangularShape retval = (RectangularShape)rect.clone();
            retval.setFrame(retval.getX() + x, retval.getY() + y, retval.getWidth(), retval.getHeight());
            return retval;
        }
        if (s instanceof Line2D) {
            Line2D line = (Line2D)s;
            Line2D retval = (Line2D)line.clone();
            retval.setLine(retval.getX1() + x, retval.getY1() + y, retval.getX2() + x, retval.getY2() + y);
            return retval;
        }
        AffineTransform af = AffineTransform.getTranslateInstance(x, y);
        Shape transformedShape = af.createTransformedShape(s);
        return transformedShape;
    }
}

