/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.ImageContainer;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentType;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;

public class ImageContent
implements Content {
    private final ImageContainer reference;
    private final StrictBounds bounds;
    private final StrictBounds imageArea;

    public ImageContent(ImageContainer ref, StrictBounds bounds) {
        this(ref, bounds, StrictGeomUtility.createBounds(0.0, 0.0, ref.getImageWidth(), ref.getImageHeight()));
    }

    protected ImageContent(ImageContainer ref, StrictBounds bounds, StrictBounds imageArea) {
        if (ref == null) {
            throw new NullPointerException("ImageContainer must not be null for ImageContent.");
        }
        if (bounds.getWidth() == 0L) {
            throw new IllegalArgumentException("A bounds width of zero is not allowed");
        }
        if (bounds.getHeight() == 0L) {
            throw new IllegalArgumentException("A bounds height of zero is not allowed");
        }
        if (imageArea.getWidth() == 0L) {
            throw new IllegalArgumentException("An image width of zero is not allowed");
        }
        if (imageArea.getHeight() == 0L) {
            throw new IllegalArgumentException("An image height of zero is not allowed");
        }
        this.reference = ref;
        this.bounds = (StrictBounds)bounds.clone();
        this.imageArea = (StrictBounds)imageArea.clone();
    }

    public StrictBounds getBounds() {
        return (StrictBounds)this.bounds.clone();
    }

    public ImageContainer getContent() {
        return this.reference;
    }

    public Content getContentForBounds(StrictBounds bounds) {
        if (!StrictBounds.intersects(bounds, this.bounds)) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds myBounds = bounds.createIntersection(this.bounds);
        StrictBounds imageArea = new StrictBounds(this.mapHorizontalPointToImage(myBounds.getX() - this.bounds.getX()), this.mapVerticalPointToImage(myBounds.getY() - this.bounds.getY()), this.mapHorizontalPointToImage(myBounds.getWidth()), this.mapVerticalPointToImage(myBounds.getHeight()));
        return new ImageContent(this.reference, myBounds, imageArea);
    }

    public ContentType getContentType() {
        return ContentType.IMAGE;
    }

    public StrictBounds getImageArea() {
        return (StrictBounds)this.imageArea.clone();
    }

    public StrictBounds getMinimumContentSize() {
        return this.getBounds();
    }

    private long mapHorizontalPointToImage(long px) {
        return px * this.imageArea.getWidth() / this.bounds.getWidth();
    }

    private long mapVerticalPointToImage(long px) {
        return px * this.imageArea.getHeight() / this.bounds.getHeight();
    }

    public void translate(long x, long y) {
        this.bounds.setRect(this.bounds.getX() + x, this.bounds.getY() + y, this.bounds.getWidth(), this.bounds.getHeight());
        this.imageArea.setRect(this.imageArea.getX() + x, this.imageArea.getY() + y, this.imageArea.getWidth(), this.imageArea.getHeight());
    }
}

