/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.content.Content;
import org.jfree.report.content.ContentType;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.MultipartContent;
import org.jfree.report.util.geom.StrictBounds;

public class ContentContainer
implements MultipartContent {
    private Content[] content;
    private int size;
    private final StrictBounds bounds;

    protected ContentContainer(StrictBounds bounds) {
        this.bounds = (StrictBounds)bounds.clone();
    }

    protected void addContentPart(Content cp) {
        if (this.size == 0) {
            this.content = new Content[10];
            this.content[0] = cp;
            this.size = 1;
        } else {
            if (this.size + 1 >= this.content.length) {
                Content[] newContent = new Content[this.size + 10];
                System.arraycopy(this.content, 0, newContent, 0, this.size);
                this.content = newContent;
            }
            this.content[this.size] = cp;
            ++this.size;
        }
    }

    public StrictBounds getBounds() {
        return (StrictBounds)this.bounds.clone();
    }

    public Content getContentForBounds(StrictBounds bounds) {
        ContentContainer cc = null;
        int i = 0;
        while (i < this.getContentPartCount()) {
            StrictBounds cbounds;
            Content retval;
            Content contentPart = this.getContentPart(i);
            if (StrictBounds.intersects(contentPart.getBounds(), bounds) && !((retval = contentPart.getContentForBounds(bounds)) instanceof EmptyContent) && (cbounds = retval.getBounds()).getHeight() != 0L && cbounds.getWidth() != 0L) {
                if (cc == null) {
                    cc = new ContentContainer(bounds);
                }
                cc.addContentPart(retval);
            }
            ++i;
        }
        if (cc == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        return cc;
    }

    public Content getContentPart(int part) {
        return this.content[part];
    }

    public int getContentPartCount() {
        return this.size;
    }

    public ContentType getContentType() {
        return ContentType.CONTAINER;
    }

    public StrictBounds getMinimumContentSize() {
        StrictBounds retval = null;
        int i = 0;
        while (i < this.getContentPartCount()) {
            Content contentPart = this.getContentPart(i);
            StrictBounds minCBounds = contentPart.getMinimumContentSize();
            if (minCBounds != null) {
                if (retval == null) {
                    retval = minCBounds;
                } else {
                    retval.add(minCBounds);
                }
            }
            ++i;
        }
        return retval;
    }

    protected void setBounds(long x, long y, long width, long height) {
        this.bounds.setRect(x, y, width, height);
    }

    public String toString() {
        StringBuffer container = new StringBuffer();
        container.append(this.getClass().getName());
        container.append("={\n");
        int i = 0;
        while (i < this.getContentPartCount()) {
            container.append(this.getContentPart(i));
            container.append("\n");
            ++i;
        }
        container.append("}\n");
        return container.toString();
    }

    public void translate(long x, long y) {
        this.bounds.setRect(this.bounds.getX() + x, this.bounds.getY() + y, this.bounds.getWidth(), this.bounds.getHeight());
        int i = 0;
        while (i < this.size) {
            Content cc = this.content[i];
            cc.translate(x, y);
            ++i;
        }
    }
}

