/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.jfree.report.LocalImageContainer;
import org.jfree.report.URLImageContainer;
import org.jfree.report.resourceloader.ImageFactory;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.WaitingImageObserver;

public class DefaultImageReference
implements Serializable,
URLImageContainer,
LocalImageContainer {
    private Image image;
    private URL url;
    private int width;
    private int height;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;

    public DefaultImageReference(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public DefaultImageReference(Image img) throws IOException {
        if (img == null) {
            throw new NullPointerException();
        }
        this.image = img;
        WaitingImageObserver obs = new WaitingImageObserver(this.image);
        obs.waitImageLoaded();
        if (obs.isError()) {
            throw new IOException("Failed to load the image. ImageObserver signaled an error.");
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
    }

    public DefaultImageReference(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL must not be null.");
        }
        this.url = url;
        this.image = ImageFactory.getInstance().createImage(url);
        if (this.image == null) {
            throw new IOException("The image could not be loaded.");
        }
        WaitingImageObserver wob = new WaitingImageObserver(this.image);
        wob.waitImageLoaded();
        if (wob.isError()) {
            throw new IOException("Failed to load the image. ImageObserver signaled an error.");
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
    }

    public DefaultImageReference(DefaultImageReference parent) {
        if (parent == null) {
            throw new NullPointerException("The given parent must not be null.");
        }
        this.width = parent.width;
        this.height = parent.height;
        this.image = parent.image;
        this.url = parent.url;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultImageReference ref = (DefaultImageReference)super.clone();
        return ref;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DefaultImageReference)) {
            return false;
        }
        DefaultImageReference ref = (DefaultImageReference)o;
        if (!ObjectUtilities.equal((Object)this.url, (Object)ref.url)) {
            return false;
        }
        if (this.width != ref.width) {
            return false;
        }
        if (this.height != ref.height) {
            return false;
        }
        if (this.scaleX != ref.scaleX) {
            return false;
        }
        return this.scaleY == ref.scaleY;
    }

    public Object getIdentity() {
        return this.url;
    }

    public Image getImage() {
        return this.image;
    }

    public int getImageHeight() {
        return this.height;
    }

    public int getImageWidth() {
        return this.width;
    }

    public String getName() {
        if (this.url != null) {
            return this.url.toExternalForm();
        }
        return null;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public URL getSourceURL() {
        return this.url;
    }

    public String getSourceURLString() {
        if (this.url == null) {
            return null;
        }
        return this.url.toExternalForm();
    }

    public int hashCode() {
        int result = this.width;
        result = 29 * result + this.height;
        result = 29 * result + Float.floatToIntBits(this.scaleX);
        result = 29 * result + Float.floatToIntBits(this.scaleY);
        result = 29 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 29 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public boolean isIdentifiable() {
        return this.url != null;
    }

    public boolean isLoadable() {
        return this.getSourceURL() != null;
    }

    public void setScale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ImageReference={ URL=");
        buf.append(this.getSourceURL());
        buf.append(", image=");
        buf.append(this.getImage());
        buf.append(", width=");
        buf.append(this.getImageWidth());
        buf.append(", height=");
        buf.append(this.getImageHeight());
        buf.append(", scaleX=");
        buf.append(this.getScaleX());
        buf.append(", scaleY=");
        buf.append(this.getScaleY());
        buf.append("}");
        return buf.toString();
    }
}

