/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.PrintHelper;
import jas.util.border.ShadowBorder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class PlotComponent
extends JComponent {
    public static final int OTHER = -1;
    public static final int NONE = 0;
    public static final int BEVEL_IN = 1;
    public static final int BEVEL_OUT = 2;
    public static final int ETCHED = 3;
    public static final int LINE = 4;
    public static final int SHADOW = 5;
    private boolean paintBackground;

    public PlotComponent() {
    }

    public PlotComponent(LayoutManager layout) {
        this.setLayout(layout);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.paintBackground && !PrintHelper.isPrinting()) {
            Insets i = this.getInsets();
            g.setColor(this.getBackground());
            g.fillRect(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.paintBackground = bg != null;
    }

    public boolean isPaintingBackground() {
        return this.paintBackground;
    }

    public void setBorderType(int type) {
        this.setBorder(PlotComponent.createBorder(type));
    }

    public int getBorderType() {
        return PlotComponent.getBorderType(this.getBorder());
    }

    static Border createBorder(int type) {
        switch (type) {
            case 1: {
                return BorderFactory.createLoweredBevelBorder();
            }
            case 2: {
                return BorderFactory.createRaisedBevelBorder();
            }
            case 3: {
                return BorderFactory.createEtchedBorder();
            }
            case 5: {
                return ShadowBorder.createShadowBorder();
            }
            case 4: {
                return BorderFactory.createLineBorder(Color.black);
            }
        }
        return null;
    }

    static int getBorderType(Border b) {
        if (b == null) {
            return 0;
        }
        if (b == BorderFactory.createLoweredBevelBorder()) {
            return 1;
        }
        if (b == BorderFactory.createRaisedBevelBorder()) {
            return 2;
        }
        if (b == BorderFactory.createEtchedBorder()) {
            return 3;
        }
        if (b instanceof LineBorder) {
            return 4;
        }
        if (b instanceof ShadowBorder) {
            return 5;
        }
        return -1;
    }
}

