/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import org.freehep.xml.util.BadXMLException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXTraverser
extends DefaultHandler {
    private SAXTraverser previous;
    private XMLReader parser;
    private int stack = 0;

    public void setReader(XMLReader reader) {
        this.parser = reader;
        reader.setContentHandler(this);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        SAXTraverser newHandler = this.handleElement(qName = qName.intern(), attrs);
        if (newHandler != this) {
            newHandler.handleElementAttributes(attrs);
            newHandler.previous = this;
            newHandler.parser = this.parser;
            this.parser.setContentHandler(newHandler);
        } else {
            ++this.stack;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.stack == 0) {
            this.handleEndElement(localName);
            this.previous.handleSubElement(this);
            this.parser.setContentHandler(this.previous);
        } else {
            --this.stack;
        }
    }

    protected void handleElementAttributes(Attributes atts) throws SAXException {
    }

    protected void handleEndElement(String name) throws SAXException {
    }

    protected void handleSubElement(SAXTraverser sub) throws SAXException {
    }

    protected SAXTraverser handleElement(String name, Attributes attrs) throws SAXException {
        throw new BadXMLException("Unhandled element " + name);
    }

    public boolean toBoolean(String value) throws BadXMLException {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new BadXMLException("Bad boolean value " + value);
    }

    public double toDouble(String value) throws SAXException {
        try {
            return new Double(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad double value " + value);
        }
    }

    public float toFloat(String value) throws SAXException {
        try {
            return Float.parseFloat(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad float value " + value);
        }
    }

    public int toInt(String value) throws SAXException {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad integer value " + value);
        }
    }

    public short toShort(String value) throws SAXException {
        try {
            return Short.parseShort(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad short value " + value);
        }
    }

    public long toLong(String value) throws SAXException {
        try {
            return Long.parseLong(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad long value " + value);
        }
    }

    public byte toByte(String value) throws SAXException {
        try {
            return Byte.parseByte(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad byte value " + value);
        }
    }
}

