/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Vector;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.RTTI;

public class IField {
    private INamedType namedType;
    private Vector comments;
    private IField next;

    IField(INamedType namedType, Vector comments) {
        this.namedType = namedType;
        this.comments = comments;
        this.next = null;
    }

    public String[] getComments(String language) {
        return RTTI.getComments(this.comments, language);
    }

    public INamedType getNamedType() {
        return this.namedType;
    }

    public IField getNext() {
        return this.next;
    }

    public void setNext(IField next) {
        this.next = next;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        String[] comments = this.getComments(null);
        for (int i = 0; i < comments.length; ++i) {
            s.append(comments[i]);
        }
        s.append("\n");
        s.append("    ");
        s.append("public ");
        s.append(this.getNamedType().getType());
        s.append(" ");
        IField field = this;
        while (field != null) {
            INamedType namedType = field.getNamedType();
            s.append(namedType.getName());
            if (namedType.getInit() != null) {
                s.append(" = ");
                s.append(namedType.getInit());
            }
            if ((field = field.getNext()) == null) continue;
            s.append(", ");
        }
        s.append(";");
        return s.toString();
    }
}

