/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSReal;
import org.freehep.postscript.PSSimple;
import org.freehep.postscript.PathOperator;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.Undefined;

class UPath
extends PathOperator {
    private double[] coord;

    UPath() {
        this.operandTypes = new Class[]{PSBoolean.class};
        this.coord = new double[6];
    }

    @Override
    public boolean execute(OperandStack os) {
        AffineTransform inverse;
        boolean ucache = os.popBoolean().getValue();
        try {
            inverse = os.gstate().getTransform().createInverse();
        }
        catch (NoninvertibleTransformException e) {
            UPath.error(os, new Undefined());
            return true;
        }
        PathIterator iterator = os.gstate().path().getPathIterator(inverse);
        Vector<PSSimple> path = new Vector<PSSimple>();
        if (ucache) {
            path.add(new PSName("ucache", true));
        }
        Rectangle2D bb = os.gstate().path().getBounds2D();
        path.add(new PSReal(bb.getMinX()));
        path.add(new PSReal(bb.getMinY()));
        path.add(new PSReal(bb.getMaxX()));
        path.add(new PSReal(bb.getMaxY()));
        path.add(new PSName("setbbox", true));
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(this.coord)) {
                case 0: {
                    path.add(new PSReal(this.coord[0]));
                    path.add(new PSReal(this.coord[1]));
                    path.add(new PSName("moveto", true));
                    break;
                }
                case 1: {
                    path.add(new PSReal(this.coord[0]));
                    path.add(new PSReal(this.coord[1]));
                    path.add(new PSName("lineto", true));
                    break;
                }
                case 3: {
                    path.add(new PSReal(this.coord[0]));
                    path.add(new PSReal(this.coord[1]));
                    path.add(new PSReal(this.coord[2]));
                    path.add(new PSReal(this.coord[3]));
                    path.add(new PSReal(this.coord[4]));
                    path.add(new PSReal(this.coord[5]));
                    path.add(new PSName("curveto", true));
                    break;
                }
                case 4: {
                    path.add(new PSName("closepath", true));
                    break;
                }
                default: {
                    UPath.error(os, new RangeCheck());
                    return true;
                }
            }
            iterator.next();
        }
        Object[] obj = new PSObject[path.size()];
        path.copyInto(obj);
        PSPackedArray upath = new PSPackedArray((PSObject[])obj);
        upath.setExecutable();
        os.push(upath);
        return true;
    }
}

