/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ArithmeticOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSNumber;

class Sub
extends ArithmeticOperator {
    Sub() {
        this.operandTypes = new Class[]{PSNumber.class, PSNumber.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSInteger.class, PSInteger.class)) {
            PSInteger n2 = os.popInteger();
            PSInteger n1 = os.popInteger();
            long d = (long)n1.getValue() - (long)n2.getValue();
            if (Integer.MIN_VALUE <= d && d <= Integer.MAX_VALUE) {
                os.push((int)d);
            } else {
                os.push(d);
            }
        } else {
            PSNumber n2 = os.popNumber();
            PSNumber n1 = os.popNumber();
            double d = n1.getDouble() - n2.getDouble();
            os.push(d);
        }
        return true;
    }
}

