/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.freehep.postscript.FontOperator;
import org.freehep.postscript.NoCurrentPoint;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSString;
import org.freehep.postscript.TypeCheck;

class Show
extends FontOperator {
    private String text;
    private int index;
    private double sx;
    private double sy;

    public Show() {
    }

    public Show(String t, double sx, double sy) {
        this.text = t;
        this.index = -1;
        this.sx = sx;
        this.sy = sy;
    }

    @Override
    public boolean execute(OperandStack os) {
        PSGState gs = os.gstate();
        if (this.text == null) {
            if (!os.checkType(PSString.class)) {
                Show.error(os, new TypeCheck());
                return true;
            }
            Point2D point = gs.position();
            if (point == null) {
                Show.error(os, new NoCurrentPoint());
                return true;
            }
            float x0 = (float)point.getX();
            float y0 = (float)point.getY();
            String t = os.popString().getValue();
            double[] cfm = gs.font().getPackedArray("FontMatrix").toDoubles();
            AffineTransform at = new AffineTransform(cfm[0], cfm[1], cfm[2], cfm[3], (double)x0, (double)y0);
            double sx = at.getScaleX();
            double sy = at.getScaleY();
            os.execStack().pop();
            os.execStack().push(new Show(t, sx, sy));
            os.gsave();
            gs.transform(at);
            return false;
        }
        if (this.index >= 0) {
            gs.translate(this.currentGlyph.wx, this.currentGlyph.wy);
        }
        ++this.index;
        if (this.index >= this.text.length()) {
            Point2D t = gs.position();
            os.grestore();
            Point2D p = os.gstate().position();
            os.gstate().path().moveTo((float)(p.getX() - t.getX() * this.sx), (float)(p.getY() - t.getY() * this.sy));
            return true;
        }
        char ch = this.text.charAt(this.index);
        this.show(os, ch);
        return false;
    }
}

