/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.FontOperator;
import org.freehep.postscript.InvalidFont;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.TypeCheck;

class SelectFont
extends FontOperator {
    SelectFont() {
        this.operandTypes = new Class[]{PSName.class, PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSName key;
        PSPackedArray matrix;
        if (os.checkType(PSName.class, PSNumber.class)) {
            double scale = os.popNumber().getDouble();
            matrix = new PSPackedArray(new double[]{scale, 0.0, 0.0, scale, 0.0, 0.0});
            key = os.popName();
        } else if (os.checkType(PSName.class, PSPackedArray.class)) {
            matrix = os.popPackedArray();
            key = os.popName();
        } else {
            SelectFont.error(os, new TypeCheck());
            return true;
        }
        PSDictionary font = this.findFont(os.dictStack().fontDirectory(), key);
        if (font == null) {
            SelectFont.error(os, new InvalidFont());
            return true;
        }
        this.defineFont(os.dictStack().fontDirectory(), key, font);
        font = this.makeFont(font, matrix.toDoubles());
        this.setFont(os, font);
        return true;
    }
}

