/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.MatrixOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class Rotate
extends MatrixOperator {
    Rotate() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSNumber.class)) {
            double angle = os.popNumber().getDouble();
            os.gstate().rotate(Math.toRadians(angle));
        } else if (os.checkType(PSNumber.class, PSArray.class)) {
            PSArray a = os.popArray();
            if (a.size() >= 6) {
                double theta = Math.toRadians(os.popNumber().getDouble());
                double sinTheta = Math.sin(theta);
                double cosTheta = Math.cos(theta);
                a.set(0, cosTheta);
                a.set(1, sinTheta);
                a.set(2, -sinTheta);
                a.set(3, cosTheta);
                a.set(4, 0);
                a.set(5, 0);
                os.push(a);
            } else {
                Rotate.error(os, new RangeCheck());
            }
        } else {
            Rotate.error(os, new TypeCheck());
        }
        return true;
    }
}

