/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Stack;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PathOperator;
import org.freehep.postscript.RangeCheck;

class ReversePath
extends PathOperator {
    private float[] coord = new float[6];
    private Stack stack;

    ReversePath() {
    }

    private void createSubPath(GeneralPath reverse) {
        while (!this.stack.empty()) {
            float y;
            float x;
            String s = (String)this.stack.pop();
            if (s.equals("moveto")) {
                x = ((Float)this.stack.pop()).floatValue();
                y = ((Float)this.stack.pop()).floatValue();
                reverse.moveTo(x, y);
                continue;
            }
            if (s.equals("lineto")) {
                x = ((Float)this.stack.pop()).floatValue();
                y = ((Float)this.stack.pop()).floatValue();
                reverse.lineTo(x, y);
                continue;
            }
            float cx1 = ((Float)this.stack.pop()).floatValue();
            float cy1 = ((Float)this.stack.pop()).floatValue();
            float cx2 = ((Float)this.stack.pop()).floatValue();
            float cy2 = ((Float)this.stack.pop()).floatValue();
            float x2 = ((Float)this.stack.pop()).floatValue();
            float y2 = ((Float)this.stack.pop()).floatValue();
            reverse.curveTo(cx1, cy1, cx2, cy2, x2, y2);
        }
    }

    @Override
    public boolean execute(OperandStack os) {
        this.stack = new Stack();
        GeneralPath path = (GeneralPath)os.gstate().path().clone();
        PathIterator iterator = path.getPathIterator(new AffineTransform());
        GeneralPath reverse = os.gstate().newPath();
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(this.coord)) {
                case 0: {
                    this.createSubPath(reverse);
                    this.stack.push(new Float(this.coord[1]));
                    this.stack.push(new Float(this.coord[0]));
                    break;
                }
                case 1: {
                    this.stack.push("lineto");
                    this.stack.push(new Float(this.coord[1]));
                    this.stack.push(new Float(this.coord[0]));
                    break;
                }
                case 3: {
                    this.stack.push(new Float(this.coord[1]));
                    this.stack.push(new Float(this.coord[0]));
                    this.stack.push(new Float(this.coord[3]));
                    this.stack.push(new Float(this.coord[2]));
                    this.stack.push("curveto");
                    this.stack.push(new Float(this.coord[5]));
                    this.stack.push(new Float(this.coord[4]));
                    break;
                }
                case 4: {
                    this.stack.push("moveto");
                    this.createSubPath(reverse);
                    reverse.closePath();
                    break;
                }
                default: {
                    ReversePath.error(os, new RangeCheck());
                    return true;
                }
            }
            iterator.next();
        }
        return true;
    }
}

