/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.Rectangle2D;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PaintingOperator;
import org.freehep.postscript.TypeCheck;

class RectFill
extends PaintingOperator {
    RectFill() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSNumber.class, PSNumber.class, PSNumber.class, PSNumber.class)) {
            double h = os.popNumber().getDouble();
            double w = os.popNumber().getDouble();
            double y = os.popNumber().getDouble();
            double x = os.popNumber().getDouble();
            Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
            os.gstate().fill(r);
        } else if (os.checkType(PSPackedArray.class)) {
            PSPackedArray a = os.popPackedArray();
            for (int i = 0; i < a.size() / 4; ++i) {
                double x = ((PSNumber)a.get(i * 4)).getDouble();
                double y = ((PSNumber)a.get(i * 4 + 1)).getDouble();
                double w = ((PSNumber)a.get(i * 4 + 2)).getDouble();
                double h = ((PSNumber)a.get(i * 4 + 3)).getDouble();
                Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
                os.gstate().fill(r);
            }
        } else {
            RectFill.error(os, new TypeCheck());
        }
        return true;
    }
}

