/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class PutInterval
extends GeneralOperator {
    PutInterval() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSArray.class, PSInteger.class, PSPackedArray.class)) {
            PSPackedArray a2 = os.popPackedArray();
            PSInteger i = os.popInteger();
            PSArray a1 = os.popArray();
            if (i.getValue() < 0 || i.getValue() + a2.size() > a1.size()) {
                PutInterval.error(os, new RangeCheck());
            } else {
                for (int j = 0; j < a2.size(); ++j) {
                    a1.set(i.getValue() + j, a2.get(j));
                }
            }
        } else if (os.checkType(PSString.class, PSInteger.class, PSString.class)) {
            PSString s2 = os.popString();
            PSInteger i = os.popInteger();
            PSString s1 = os.popString();
            if (i.getValue() < 0 || i.getValue() + s2.size() > s1.size()) {
                PutInterval.error(os, new RangeCheck());
            } else {
                for (int j = 0; j < s2.size(); ++j) {
                    s1.set(i.getValue() + j, s2.get(j));
                }
            }
        } else {
            PutInterval.error(os, new TypeCheck());
        }
        return true;
    }
}

