/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class Put
extends GeneralOperator {
    Put() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSArray.class, PSInteger.class, PSObject.class)) {
            PSObject o = os.popObject();
            PSInteger i = os.popInteger();
            PSArray a = os.popArray();
            if (i.getValue() < 0 || i.getValue() >= a.size()) {
                Put.error(os, new RangeCheck());
            } else {
                a.set(i.getValue(), o);
            }
        } else if (os.checkType(PSDictionary.class, PSObject.class, PSObject.class)) {
            PSObject o = os.popObject();
            PSObject key = os.popObject();
            PSDictionary d = os.popDictionary();
            d.put(key, o);
            o.setName(key.cvs());
        } else if (os.checkType(PSString.class, PSInteger.class, PSInteger.class)) {
            PSInteger o = os.popInteger();
            PSInteger i = os.popInteger();
            PSString s = os.popString();
            if (i.getValue() < 0 || i.getValue() >= s.size()) {
                Put.error(os, new RangeCheck());
            } else {
                s.set(i.getValue(), o.getValue());
            }
        } else {
            Put.error(os, new TypeCheck());
        }
        return true;
    }
}

