/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.PSNumber;
import org.freehep.postscript.RangeException;

public class PSReal
extends PSNumber {
    private double value;

    public PSReal(double v) {
        super("real");
        this.value = v;
    }

    @Override
    public String getType() {
        return "realtype";
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int getInt() throws RangeException {
        if (this.value < -2.147483648E9 || this.value > 2.147483647E9) {
            throw new RangeException();
        }
        return (int)this.value;
    }

    public int compareTo(Object o) {
        double d2;
        double d1 = this.getValue();
        return d1 > (d2 = ((PSNumber)o).getDouble()) ? 1 : (d1 < d2 ? -1 : 0);
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSReal) {
            return this.value == ((PSReal)o).getValue();
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSReal(this.value);
    }

    @Override
    public String cvs() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }
}

