/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.postscript.PSDataTarget;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSObject;
import org.freehep.util.io.FinishableOutputStream;

public class PSOutputFile
extends PSFile
implements PSDataTarget {
    protected OutputStream out = null;
    protected boolean append;

    protected PSOutputFile(String n, boolean f, OutputStream o) {
        super(n, f);
        this.out = o;
    }

    public PSOutputFile(OutputStream output) throws IOException {
        super("pipe", true);
        this.init(output);
    }

    public PSOutputFile(String filename, boolean append, boolean secure) throws IOException {
        super(filename, false);
        if (!secure) {
            throw new IOException();
        }
        this.append = append;
        this.init(new FileOutputStream(filename, append));
    }

    private void init(OutputStream output) {
        this.out = new BufferedOutputStream(output);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            if (!this.filter) {
                this.out.close();
            } else if (this.out instanceof FinishableOutputStream) {
                ((FinishableOutputStream)((Object)this.out)).finish();
            }
            this.out = null;
        }
    }

    @Override
    public void write(int b, boolean secure) throws IOException {
        if (!secure) {
            throw new IOException();
        }
        if (this.out == null) {
            throw new IOException();
        }
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public boolean isValid() {
        return this.out != null;
    }

    @Override
    public int hashCode() {
        return this.out.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSOutputFile) {
            return this.out == ((PSOutputFile)o).out;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSOutputFile(this.filename, this.filter, this.out);
    }

    @Override
    public PSObject copy() {
        if (this.filter) {
            throw new RuntimeException("Filters cannot be copied");
        }
        try {
            return new PSOutputFile(this.filename, this.append, true);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException for file while copying: " + this.filename);
        }
    }
}

