/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.freehep.postscript.FontOperator;
import org.freehep.postscript.NoCurrentPoint;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.TypeCheck;

class KShow
extends FontOperator {
    private int index;
    private String text;
    private PSPackedArray proc;
    private boolean skip;

    private KShow(PSPackedArray p, String t) {
        this.proc = p;
        this.text = t;
        this.index = -1;
        this.skip = true;
    }

    public KShow() {
    }

    @Override
    public boolean execute(OperandStack os) {
        PSGState gs = os.gstate();
        if (this.proc == null) {
            if (!os.checkType(PSPackedArray.class, PSString.class)) {
                KShow.error(os, new TypeCheck());
                return true;
            }
            Point2D point = gs.position();
            if (point == null) {
                KShow.error(os, new NoCurrentPoint());
                return true;
            }
            float x0 = (float)point.getX();
            float y0 = (float)point.getY();
            String t = os.popString().getValue();
            PSPackedArray p = os.popPackedArray();
            os.execStack().pop();
            os.execStack().push(new KShow(p, t));
            os.gsave();
            double[] cfm = gs.font().getPackedArray("FontMatrix").toDoubles();
            AffineTransform at = new AffineTransform(cfm[0], cfm[1], cfm[2], cfm[3], (double)x0, (double)y0);
            gs.transform(at);
            return false;
        }
        if (!this.skip) {
            double wx = this.currentGlyph.wx;
            double wy = this.currentGlyph.wy;
            os.gstate().translate(wx, wy);
            if (this.index < this.text.length() - 1) {
                char c0 = this.text.charAt(this.index);
                char c1 = this.text.charAt(this.index + 1);
                os.push(c0);
                os.push(c1);
                os.execStack().push(this.proc);
                this.skip = true;
                return false;
            }
        }
        ++this.index;
        if (this.index >= this.text.length()) {
            os.grestore();
            return true;
        }
        char ch = this.text.charAt(this.index);
        this.show(os, ch);
        this.skip = false;
        return false;
    }
}

