/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.freehep.postscript.MatrixOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.UndefinedResult;

class InvertMatrix
extends MatrixOperator {
    InvertMatrix() {
        this.operandTypes = new Class[]{PSPackedArray.class, PSArray.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSArray m2 = os.popArray();
        PSPackedArray m1 = os.popPackedArray();
        try {
            AffineTransform transform = new AffineTransform(m1.toDoubles());
            AffineTransform inverse = transform.createInverse();
            double[] d = new double[6];
            inverse.getMatrix(d);
            m2.set(d);
            os.push(m2);
        }
        catch (NoninvertibleTransformException e) {
            InvertMatrix.error(os, new UndefinedResult());
        }
        return true;
    }
}

