/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.LoopingContext;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.TypeCheck;

class ForAll
extends GeneralOperator
implements LoopingContext {
    private int index;
    private PSPackedArray array;
    private Object[] keys;
    private PSDictionary dictionary;
    private PSString string;
    private PSPackedArray proc;

    private ForAll(PSPackedArray a, PSPackedArray p) {
        this.array = a;
        this.proc = p;
        this.index = 0;
    }

    private ForAll(PSDictionary d, PSPackedArray p) {
        this.dictionary = d;
        this.proc = p;
        this.keys = this.dictionary.keys();
        this.index = 0;
    }

    private ForAll(PSString s, PSPackedArray p) {
        this.string = s;
        this.proc = p;
        this.index = 0;
    }

    public ForAll() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.proc == null) {
            if (os.checkType(PSPackedArray.class, PSPackedArray.class)) {
                PSPackedArray p = os.popPackedArray();
                PSPackedArray a = os.popPackedArray();
                os.execStack().pop();
                os.execStack().push(new ForAll(a, p));
                return false;
            }
            if (os.checkType(PSDictionary.class, PSPackedArray.class)) {
                PSPackedArray p = os.popPackedArray();
                PSDictionary d = os.popDictionary();
                os.execStack().pop();
                os.execStack().push(new ForAll(d, p));
                return false;
            }
            if (os.checkType(PSString.class, PSPackedArray.class)) {
                PSPackedArray p = os.popPackedArray();
                PSString s = os.popString();
                os.execStack().pop();
                os.execStack().push(new ForAll(s, p));
                return false;
            }
            ForAll.error(os, new TypeCheck());
        } else {
            if (this.array != null) {
                if (this.index < this.array.size()) {
                    os.push(this.array.get(this.index));
                    os.execStack().push(this.proc);
                    ++this.index;
                    return false;
                }
                return true;
            }
            if (this.dictionary != null) {
                if (this.index < this.keys.length) {
                    PSObject value = this.dictionary.get((PSObject)this.keys[this.index]);
                    if (value != null) {
                        os.push(this.keys[this.index]);
                        os.push((Object)value);
                        os.execStack().push(this.proc);
                    }
                    ++this.index;
                    return false;
                }
                return true;
            }
            if (this.string != null) {
                if (this.index < this.string.size()) {
                    os.push(this.string.get(this.index));
                    os.execStack().push(this.proc);
                    ++this.index;
                    return false;
                }
                return true;
            }
            System.err.println("Fatal Error in ForAll");
        }
        return false;
    }
}

