/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ControlOperator;
import org.freehep.postscript.LoopingContext;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSReal;
import org.freehep.postscript.TypeCheck;

class For
extends ControlOperator
implements LoopingContext {
    private PSPackedArray procedure = null;
    private int iLimit = 0;
    private int iIncrement = 0;
    private int iCount = 0;
    private double rLimit = 0.0;
    private double rIncrement = 0.0;
    private double rCount = 0.0;
    private boolean real = false;

    public For() {
    }

    private For(int start, int inc, int limit, PSPackedArray p) {
        this.iCount = start;
        this.iIncrement = inc;
        this.iLimit = limit;
        this.procedure = p;
        this.real = false;
    }

    public For(double start, double inc, double limit, PSPackedArray p) {
        this.rCount = start;
        this.rIncrement = inc;
        this.rLimit = limit;
        this.procedure = p;
        this.real = true;
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.procedure == null) {
            if (!os.checkType(PSNumber.class, PSNumber.class, PSNumber.class, PSPackedArray.class)) {
                For.error(os, new TypeCheck());
                return true;
            }
            PSPackedArray p = os.popPackedArray();
            PSNumber limit = os.popNumber();
            PSNumber inc = os.popNumber();
            PSNumber start = os.popNumber();
            os.execStack().pop();
            if (limit instanceof PSReal || inc instanceof PSReal || start instanceof PSReal) {
                os.execStack().push(new For(start.getDouble(), inc.getDouble(), limit.getDouble(), p));
            } else {
                os.execStack().push(new For(((PSInteger)start).getValue(), ((PSInteger)inc).getValue(), ((PSInteger)limit).getValue(), p));
            }
            return false;
        }
        if (this.real) {
            if (this.rIncrement >= 0.0 && this.rCount <= this.rLimit) {
                os.push(this.rCount);
                os.execStack().push(this.procedure);
                this.rCount += this.rIncrement;
                return false;
            }
            if (this.rIncrement < 0.0 && this.rCount >= this.rLimit) {
                os.push(this.rCount);
                os.execStack().push(this.procedure);
                this.rCount += this.rIncrement;
                return false;
            }
        } else {
            if (this.iIncrement >= 0 && this.iCount <= this.iLimit) {
                os.push(this.iCount);
                os.execStack().push(this.procedure);
                this.iCount += this.iIncrement;
                return false;
            }
            if (this.iIncrement < 0 && this.iCount >= this.iLimit) {
                os.push(this.iCount);
                os.execStack().push(this.procedure);
                this.iCount += this.iIncrement;
                return false;
            }
        }
        return true;
    }
}

