/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.freehep.postscript.OperandStack;

public class FixedTexturePaint
extends TexturePaint {
    private OperandStack os;
    private AffineTransform matrix;

    public FixedTexturePaint(OperandStack os, AffineTransform m, BufferedImage texture, Rectangle2D anchor) {
        super(texture, anchor);
        this.os = os;
        this.matrix = m;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        AffineTransform mirror;
        try {
            mirror = this.os.gstate().getTransform();
            mirror = mirror.createInverse();
            mirror.preConcatenate(xform);
        }
        catch (NoninvertibleTransformException e) {
            System.err.println("Pattern problem: could not invert matrix");
            mirror = xform;
        }
        AffineTransform at = new AffineTransform();
        at.preConcatenate(this.matrix);
        at.preConcatenate(mirror);
        return super.createContext(cm, deviceBounds, userBounds, at, hints);
    }
}

