/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.freehep.postscript.FormOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class ExecForm
extends FormOperator {
    private boolean done;

    private ExecForm(boolean d) {
        this.done = d;
    }

    public ExecForm() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (!this.done) {
            if (!os.checkType(PSDictionary.class)) {
                ExecForm.error(os, new TypeCheck());
                return true;
            }
            PSDictionary form = os.popDictionary();
            try {
                if (form.getInteger("FormType") != 1) {
                    ExecForm.error(os, new RangeCheck());
                    return true;
                }
                AffineTransform matrix = new AffineTransform(form.getPackedArray("Matrix").toDoubles());
                double[] bbox = form.getPackedArray("BBox").toDoubles();
                PSPackedArray proc = (PSPackedArray)form.getPackedArray("PaintProc").clone();
                proc.setExecutable();
                os.gsave();
                os.gstate().transform(matrix);
                os.gstate().clip(new Rectangle2D.Double(bbox[0], bbox[1], bbox[2] - bbox[0], bbox[3] - bbox[1]));
                os.execStack().pop();
                os.execStack().push(new ExecForm(true));
                os.execStack().push(proc);
                os.push(form);
                return false;
            }
            catch (ClassCastException e) {
                ExecForm.error(os, new TypeCheck());
                return true;
            }
        }
        os.grestore();
        return true;
    }
}

