/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.DictionaryOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSMark;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.UnmatchedMark;

class EndDictionary
extends DictionaryOperator {
    EndDictionary() {
    }

    @Override
    public String getName() {
        return ">>";
    }

    @Override
    public boolean execute(OperandStack os) {
        int n = os.countToMark();
        if (n < 0) {
            EndDictionary.error(os, new UnmatchedMark());
        } else {
            PSDictionary d = new PSDictionary(n /= 2);
            for (int i = 0; i < n; ++i) {
                if (os.size() < 2) {
                    EndDictionary.error(os, new RangeCheck());
                }
                PSObject value = os.popObject();
                PSObject key = os.popObject();
                d.put(key, value);
            }
            PSMark mark = os.popMark();
            os.push(d);
        }
        return true;
    }
}

