/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import org.freehep.postscript.IOError;
import org.freehep.postscript.NameNotFoundException;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PSTokenizable;
import org.freehep.postscript.SyntaxError;
import org.freehep.postscript.SyntaxException;
import org.freehep.postscript.Undefined;

public class Dispatcher {
    private Dispatcher() {
    }

    public static boolean dispatch(OperandStack os, PSTokenizable in) {
        try {
            PSObject obj = in.token(os.packingMode(), os.dictStack());
            if (obj == null) {
                return true;
            }
            if (obj instanceof PSPackedArray) {
                os.push(obj);
            } else {
                os.execStack().push(obj);
            }
            return false;
        }
        catch (IOException e) {
            PSObject.error(os, new IOError());
            return true;
        }
        catch (SyntaxException e) {
            PSArray errorInfo = new PSArray(2);
            errorInfo.set(0, new PSInteger(e.getLineNo()));
            errorInfo.set(1, new PSString(e.getMessage()));
            os.dictStack().dollarError().put("errorinfo", (PSObject)errorInfo);
            PSObject.error(os, new SyntaxError());
            return true;
        }
        catch (NameNotFoundException e) {
            PSObject.error(os, new Undefined());
            return true;
        }
    }
}

