/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.freehep.postscript.FontOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PathOperator;

class CharPath
extends PathOperator {
    CharPath() {
        this.operandTypes = new Class[]{PSString.class, PSBoolean.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        boolean strokePath = os.popBoolean().getValue();
        String text = os.popString().getValue();
        PSGState gs = os.gstate();
        float x = 0.0f;
        float y = 0.0f;
        Point2D point = gs.position();
        if (point != null) {
            x = (float)point.getX();
            y = (float)point.getY();
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            Shape outline = gs.charPath(ch, x, y, strokePath);
            if (outline != null) {
                gs.path().append(outline, false);
            }
            gs.path().moveTo(x += FontOperator.stringWidth(os, ch), y);
        }
        return true;
    }
}

