/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ArithmeticOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSNumber;

class Add
extends ArithmeticOperator {
    Add() {
        this.operandTypes = new Class[]{PSNumber.class, PSNumber.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSInteger.class, PSInteger.class)) {
            PSInteger n2 = os.popInteger();
            PSInteger n1 = os.popInteger();
            long s = (long)n1.getValue() + (long)n2.getValue();
            if (Integer.MIN_VALUE <= s && s <= Integer.MAX_VALUE) {
                os.push((int)s);
            } else {
                os.push(s);
            }
        } else {
            PSNumber n2 = os.popNumber();
            PSNumber n1 = os.popNumber();
            double s = n1.getDouble() + n2.getDouble();
            os.push(s);
        }
        return true;
    }
}

