/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import java.util.List;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MinuitParameter;
import org.freehep.math.minuit.MnCovarianceSqueeze;
import org.freehep.math.minuit.MnGlobalCorrelationCoeff;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnPrint;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.MnUserTransformation;

public class MnUserParameterState {
    private boolean theValid;
    private boolean theCovarianceValid;
    private boolean theGCCValid;
    private double theFVal;
    private double theEDM;
    private int theNFcn;
    private MnUserParameters theParameters;
    private MnUserCovariance theCovariance;
    private MnGlobalCorrelationCoeff theGlobalCC;
    private List<Double> theIntParameters;
    private MnUserCovariance theIntCovariance;

    MnUserParameterState() {
        this.theValid = false;
        this.theCovarianceValid = false;
        this.theParameters = new MnUserParameters();
        this.theCovariance = new MnUserCovariance();
        this.theIntParameters = new ArrayList<Double>();
        this.theIntCovariance = new MnUserCovariance();
    }

    protected MnUserParameterState clone() {
        return new MnUserParameterState(this);
    }

    private MnUserParameterState(MnUserParameterState other) {
        this.theValid = other.theValid;
        this.theCovarianceValid = other.theCovarianceValid;
        this.theGCCValid = other.theGCCValid;
        this.theFVal = other.theFVal;
        this.theEDM = other.theEDM;
        this.theNFcn = other.theNFcn;
        this.theParameters = other.theParameters.clone();
        this.theCovariance = other.theCovariance;
        this.theGlobalCC = other.theGlobalCC;
        this.theIntParameters = new ArrayList<Double>(other.theIntParameters);
        this.theIntCovariance = other.theIntCovariance.clone();
    }

    MnUserParameterState(double[] par, double[] err) {
        this.theValid = true;
        this.theParameters = new MnUserParameters(par, err);
        this.theCovariance = new MnUserCovariance();
        this.theGlobalCC = new MnGlobalCorrelationCoeff();
        this.theIntParameters = new ArrayList<Double>(par.length);
        for (int i = 0; i < par.length; ++i) {
            this.theIntParameters.add(par[i]);
        }
        this.theIntCovariance = new MnUserCovariance();
    }

    MnUserParameterState(MnUserParameters par) {
        this.theValid = true;
        this.theParameters = par;
        this.theCovariance = new MnUserCovariance();
        this.theGlobalCC = new MnGlobalCorrelationCoeff();
        this.theIntParameters = new ArrayList<Double>(par.variableParameters());
        this.theIntCovariance = new MnUserCovariance();
        boolean i = false;
        for (MinuitParameter ipar : par.parameters()) {
            if (ipar.isConst() || ipar.isFixed()) continue;
            if (ipar.hasLimits()) {
                this.theIntParameters.add(this.ext2int(ipar.number(), ipar.value()));
                continue;
            }
            this.theIntParameters.add(ipar.value());
        }
    }

    MnUserParameterState(double[] par, double[] cov, int nrow) {
        this.theValid = true;
        this.theCovarianceValid = true;
        this.theCovariance = new MnUserCovariance(cov, nrow);
        this.theGlobalCC = new MnGlobalCorrelationCoeff();
        this.theIntParameters = new ArrayList<Double>(par.length);
        this.theIntCovariance = new MnUserCovariance(cov, nrow);
        double[] err = new double[par.length];
        for (int i = 0; i < par.length; ++i) {
            assert (this.theCovariance.get(i, i) > 0.0);
            err[i] = Math.sqrt(this.theCovariance.get(i, i));
            this.theIntParameters.add(par[i]);
        }
        this.theParameters = new MnUserParameters(par, err);
        assert (this.theCovariance.nrow() == this.variableParameters());
    }

    MnUserParameterState(double[] par, MnUserCovariance cov) {
        this.theValid = true;
        this.theCovarianceValid = true;
        this.theCovariance = cov;
        this.theGlobalCC = new MnGlobalCorrelationCoeff();
        this.theIntParameters = new ArrayList<Double>(par.length);
        this.theIntCovariance = cov.clone();
        if (this.theCovariance.nrow() != this.variableParameters()) {
            throw new IllegalArgumentException("Bad covariance size");
        }
        double[] err = new double[par.length];
        for (int i = 0; i < par.length; ++i) {
            if (this.theCovariance.get(i, i) <= 0.0) {
                throw new IllegalArgumentException("Bad covariance");
            }
            err[i] = Math.sqrt(this.theCovariance.get(i, i));
            this.theIntParameters.add(par[i]);
        }
        this.theParameters = new MnUserParameters(par, err);
    }

    MnUserParameterState(MnUserParameters par, MnUserCovariance cov) {
        this.theValid = true;
        this.theCovarianceValid = true;
        this.theParameters = par;
        this.theCovariance = cov;
        this.theGlobalCC = new MnGlobalCorrelationCoeff();
        this.theIntParameters = new ArrayList<Double>();
        this.theIntCovariance = cov.clone();
        this.theIntCovariance.scale(0.5);
        boolean i = false;
        for (MinuitParameter ipar : par.parameters()) {
            if (ipar.isConst() || ipar.isFixed()) continue;
            if (ipar.hasLimits()) {
                this.theIntParameters.add(this.ext2int(ipar.number(), ipar.value()));
                continue;
            }
            this.theIntParameters.add(ipar.value());
        }
        assert (this.theCovariance.nrow() == this.variableParameters());
    }

    MnUserParameterState(MinimumState st, double up, MnUserTransformation trafo) {
        this.theValid = st.isValid();
        this.theCovarianceValid = false;
        this.theGCCValid = false;
        this.theFVal = st.fval();
        this.theEDM = st.edm();
        this.theNFcn = st.nfcn();
        this.theParameters = new MnUserParameters();
        this.theCovariance = new MnUserCovariance();
        this.theGlobalCC = new MnGlobalCorrelationCoeff();
        this.theIntParameters = new ArrayList<Double>();
        this.theIntCovariance = new MnUserCovariance();
        for (MinuitParameter ipar : trafo.parameters()) {
            double err;
            int i;
            if (ipar.isConst()) {
                this.add(ipar.name(), ipar.value());
                continue;
            }
            if (ipar.isFixed()) {
                this.add(ipar.name(), ipar.value(), ipar.error());
                if (ipar.hasLimits()) {
                    if (ipar.hasLowerLimit() && ipar.hasUpperLimit()) {
                        this.setLimits(ipar.name(), ipar.lowerLimit(), ipar.upperLimit());
                    } else if (ipar.hasLowerLimit() && !ipar.hasUpperLimit()) {
                        this.setLowerLimit(ipar.name(), ipar.lowerLimit());
                    } else {
                        this.setUpperLimit(ipar.name(), ipar.upperLimit());
                    }
                }
                this.fix(ipar.name());
                continue;
            }
            if (ipar.hasLimits()) {
                i = trafo.intOfExt(ipar.number());
                err = st.hasCovariance() ? Math.sqrt(2.0 * up * st.error().invHessian().get(i, i)) : st.parameters().dirin().get(i);
                this.add(ipar.name(), trafo.int2ext(i, st.vec().get(i)), trafo.int2extError(i, st.vec().get(i), err));
                if (ipar.hasLowerLimit() && ipar.hasUpperLimit()) {
                    this.setLimits(ipar.name(), ipar.lowerLimit(), ipar.upperLimit());
                    continue;
                }
                if (ipar.hasLowerLimit() && !ipar.hasUpperLimit()) {
                    this.setLowerLimit(ipar.name(), ipar.lowerLimit());
                    continue;
                }
                this.setUpperLimit(ipar.name(), ipar.upperLimit());
                continue;
            }
            i = trafo.intOfExt(ipar.number());
            err = st.hasCovariance() ? Math.sqrt(2.0 * up * st.error().invHessian().get(i, i)) : st.parameters().dirin().get(i);
            this.add(ipar.name(), st.vec().get(i), err);
        }
        this.theCovarianceValid = st.error().isValid();
        if (this.theCovarianceValid) {
            this.theCovariance = trafo.int2extCovariance(st.vec(), st.error().invHessian());
            this.theIntCovariance = new MnUserCovariance((double[])st.error().invHessian().data().clone(), st.error().invHessian().nrow());
            this.theCovariance.scale(2.0 * up);
            this.theGlobalCC = new MnGlobalCorrelationCoeff(st.error().invHessian());
            this.theGCCValid = true;
            assert (this.theCovariance.nrow() == this.variableParameters());
        }
    }

    MnUserParameters parameters() {
        return this.theParameters;
    }

    MnUserCovariance covariance() {
        return this.theCovariance;
    }

    MnGlobalCorrelationCoeff globalCC() {
        return this.theGlobalCC;
    }

    List<Double> intParameters() {
        return this.theIntParameters;
    }

    MnUserCovariance intCovariance() {
        return this.theIntCovariance;
    }

    MnUserTransformation trafo() {
        return this.theParameters.trafo();
    }

    public boolean isValid() {
        return this.theValid;
    }

    public boolean hasCovariance() {
        return this.theCovarianceValid;
    }

    public boolean hasGlobalCC() {
        return this.theGCCValid;
    }

    public double fval() {
        return this.theFVal;
    }

    public double edm() {
        return this.theEDM;
    }

    public int nfcn() {
        return this.theNFcn;
    }

    List<MinuitParameter> minuitParameters() {
        return this.theParameters.parameters();
    }

    public double[] params() {
        return this.theParameters.params();
    }

    public double[] errors() {
        return this.theParameters.errors();
    }

    MinuitParameter parameter(int i) {
        return this.theParameters.parameter(i);
    }

    public void add(String name, double val, double err) {
        this.theParameters.add(name, val, err);
        this.theIntParameters.add(val);
        this.theCovarianceValid = false;
        this.theGCCValid = false;
        this.theValid = true;
    }

    public void add(String name, double val, double err, double low, double up) {
        this.theParameters.add(name, val, err, low, up);
        this.theCovarianceValid = false;
        this.theIntParameters.add(this.ext2int(this.index(name), val));
        this.theGCCValid = false;
        this.theValid = true;
    }

    public void add(String name, double val) {
        this.theParameters.add(name, val);
        this.theValid = true;
    }

    public void fix(int e) {
        int i = this.intOfExt(e);
        if (this.theCovarianceValid) {
            this.theCovariance = MnCovarianceSqueeze.squeeze(this.theCovariance, i);
            this.theIntCovariance = MnCovarianceSqueeze.squeeze(this.theIntCovariance, i);
        }
        this.theIntParameters.remove(i);
        this.theParameters.fix(e);
        this.theGCCValid = false;
    }

    public void release(int e) {
        this.theParameters.release(e);
        this.theCovarianceValid = false;
        this.theGCCValid = false;
        int i = this.intOfExt(e);
        if (this.parameter(e).hasLimits()) {
            this.theIntParameters.add(i, this.ext2int(e, this.parameter(e).value()));
        } else {
            this.theIntParameters.add(i, this.parameter(e).value());
        }
    }

    public void setValue(int e, double val) {
        this.theParameters.setValue(e, val);
        if (!this.parameter(e).isFixed() && !this.parameter(e).isConst()) {
            int i = this.intOfExt(e);
            if (this.parameter(e).hasLimits()) {
                this.theIntParameters.set(i, this.ext2int(e, val));
            } else {
                this.theIntParameters.set(i, val);
            }
        }
    }

    public void setError(int e, double err) {
        this.theParameters.setError(e, err);
    }

    public void setLimits(int e, double low, double up) {
        this.theParameters.setLimits(e, low, up);
        this.theCovarianceValid = false;
        this.theGCCValid = false;
        if (!this.parameter(e).isFixed() && !this.parameter(e).isConst()) {
            int i = this.intOfExt(e);
            if (low < this.theIntParameters.get(i) && this.theIntParameters.get(i) < up) {
                this.theIntParameters.set(i, this.ext2int(e, this.theIntParameters.get(i)));
            } else {
                this.theIntParameters.set(i, this.ext2int(e, 0.5 * (low + up)));
            }
        }
    }

    public void setUpperLimit(int e, double up) {
        this.theParameters.setUpperLimit(e, up);
        this.theCovarianceValid = false;
        this.theGCCValid = false;
        if (!this.parameter(e).isFixed() && !this.parameter(e).isConst()) {
            int i = this.intOfExt(e);
            if (this.theIntParameters.get(i) < up) {
                this.theIntParameters.set(i, this.ext2int(e, this.theIntParameters.get(i)));
            } else {
                this.theIntParameters.set(i, this.ext2int(e, up - 0.5 * Math.abs(up + 1.0)));
            }
        }
    }

    public void setLowerLimit(int e, double low) {
        this.theParameters.setLowerLimit(e, low);
        this.theCovarianceValid = false;
        this.theGCCValid = false;
        if (!this.parameter(e).isFixed() && !this.parameter(e).isConst()) {
            int i = this.intOfExt(e);
            if (low < this.theIntParameters.get(i)) {
                this.theIntParameters.set(i, this.ext2int(e, this.theIntParameters.get(i)));
            } else {
                this.theIntParameters.set(i, this.ext2int(e, low + 0.5 * Math.abs(low + 1.0)));
            }
        }
    }

    public void removeLimits(int e) {
        this.theParameters.removeLimits(e);
        this.theCovarianceValid = false;
        this.theGCCValid = false;
        if (!this.parameter(e).isFixed() && !this.parameter(e).isConst()) {
            this.theIntParameters.set(this.intOfExt(e), this.value(e));
        }
    }

    public double value(int index) {
        return this.theParameters.value(index);
    }

    public double error(int index) {
        return this.theParameters.error(index);
    }

    public void fix(String name) {
        this.fix(this.index(name));
    }

    public void release(String name) {
        this.release(this.index(name));
    }

    public void setValue(String name, double val) {
        this.setValue(this.index(name), val);
    }

    public void setError(String name, double err) {
        this.setError(this.index(name), err);
    }

    public void setLimits(String name, double low, double up) {
        this.setLimits(this.index(name), low, up);
    }

    public void setUpperLimit(String name, double up) {
        this.setUpperLimit(this.index(name), up);
    }

    public void setLowerLimit(String name, double low) {
        this.setLowerLimit(this.index(name), low);
    }

    public void removeLimits(String name) {
        this.removeLimits(this.index(name));
    }

    public double value(String name) {
        return this.value(this.index(name));
    }

    public double error(String name) {
        return this.error(this.index(name));
    }

    public int index(String name) {
        return this.theParameters.index(name);
    }

    public String name(int index) {
        return this.theParameters.name(index);
    }

    double int2ext(int i, double val) {
        return this.theParameters.trafo().int2ext(i, val);
    }

    double ext2int(int i, double val) {
        return this.theParameters.trafo().ext2int(i, val);
    }

    int intOfExt(int ext) {
        return this.theParameters.trafo().intOfExt(ext);
    }

    public int extOfInt(int internal) {
        return this.theParameters.trafo().extOfInt(internal);
    }

    public int variableParameters() {
        return this.theParameters.variableParameters();
    }

    public MnMachinePrecision precision() {
        return this.theParameters.precision();
    }

    public void setPrecision(double eps) {
        this.theParameters.setPrecision(eps);
    }

    public String toString() {
        return MnPrint.toString(this);
    }
}

