/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class CircularArcCentre
extends CGMTag {
    protected Point2D p;
    protected Point2D dps;
    protected Point2D dpe;
    protected double radius;

    public CircularArcCentre() {
        super(4, 15, 1);
    }

    public CircularArcCentre(Point2D p, Point2D dps, Point2D dpe, double radius) {
        this();
        this.p = p;
        this.dps = dps;
        this.dpe = dpe;
        this.radius = radius;
    }

    protected CircularArcCentre(int elementClass, int elementID, int version) {
        super(elementClass, elementID, version);
    }

    @Override
    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.writePoint(this.p);
        cgm.writeVDC(this.dps.getX());
        cgm.writeVDC(this.dps.getY());
        cgm.writeVDC(this.dpe.getX());
        cgm.writeVDC(this.dpe.getY());
        cgm.writeVDC(this.radius);
    }

    @Override
    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.print("ARCCTR ");
        this.writeArcSpec(cgm);
    }

    protected void writeArcSpec(CGMWriter cgm) throws IOException {
        cgm.writePoint(this.p);
        cgm.print(", ");
        cgm.writePoint(this.dps);
        cgm.print(", ");
        cgm.writePoint(this.dpe);
    }
}

