/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.services.jnlp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.jnlp.DownloadServiceListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

class ProgressDialog
extends JOptionPane
implements DownloadServiceListener,
Runnable,
ActionListener {
    private JProgressBar progress = new JProgressBar(0, 100);
    private JLabel statusLabel = new JLabel("Status");
    private int pc = 0;
    private String status;
    private boolean failed = false;
    private boolean abort = false;
    private JButton cancel = new JButton("Cancel");

    ProgressDialog(String message) {
        JPanel messagePane = new JPanel(new BorderLayout());
        messagePane.add((Component)new JLabel(message), "North");
        messagePane.add(this.progress);
        messagePane.add((Component)this.statusLabel, "South");
        this.cancel.addActionListener(this);
        this.setMessage(messagePane);
        this.setMessageType(1);
        this.setOptions(new Object[]{this.cancel});
    }

    public void downloadFailed(URL url, String version) {
        this.failed = true;
    }

    public void progress(URL url, String version, long readSoFar, long total, int overallPercent) {
        if (this.abort) {
            throw new RuntimeException("Download aborted");
        }
        this.pc = overallPercent;
        this.status = "Downloading " + readSoFar;
        SwingUtilities.invokeLater(this);
    }

    public void upgradingArchive(URL url, String version, int patchPercent, int overallPercent) {
        if (this.abort) {
            throw new RuntimeException("Download aborted");
        }
        this.pc = overallPercent;
        this.status = "Upgrading " + patchPercent + "%";
        SwingUtilities.invokeLater(this);
    }

    public void validating(URL url, String version, long entry, long total, int overallPercent) {
        if (this.abort) {
            throw new RuntimeException("Download aborted");
        }
        this.pc = overallPercent;
        this.status = "Validating " + entry + "/" + total;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.progress.setValue(this.pc);
        this.statusLabel.setText(this.status);
    }

    void setFailed() {
        this.failed = true;
    }

    boolean isDone() {
        return !this.failed && !this.abort;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.abort = true;
    }
}

