/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.freehep.aid.AbstractGenerator;
import org.freehep.aid.AidUtil;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.IType;
import org.freehep.util.UserProperties;
import org.freehep.util.io.IndentPrintWriter;

public class PythonClassGenerator
extends AbstractGenerator {
    protected static final String language = "py";
    protected static final Set builtinTypes = new HashSet();
    protected UserProperties importProperties = new UserProperties();
    protected UserProperties typeProperties = new UserProperties();
    protected UserProperties namesProperties = new UserProperties();
    protected UserProperties valueProperties = new UserProperties();
    protected UserProperties commentProperties = new UserProperties();

    public PythonClassGenerator(String propDir) {
        AidUtil.loadProperties(this.properties, this.getClass(), propDir, "aid.py.properties");
        AidUtil.loadProperties(this.importProperties, this.getClass(), propDir, "aid.imports.py.properties");
        AidUtil.loadProperties(this.typeProperties, this.getClass(), propDir, "aid.types.py.properties");
        AidUtil.loadProperties(this.namesProperties, this.getClass(), propDir, "aid.names.py.properties");
        AidUtil.loadProperties(this.valueProperties, this.getClass(), propDir, "aid.values.py.properties");
        AidUtil.loadProperties(this.commentProperties, this.getClass(), propDir, "aid.comments.py.properties");
        this.properties.setProperty("py.interface", "true");
    }

    @Override
    public String directory(IClass clazz) {
        String directory = clazz.getPackageName();
        directory = this.typeProperties.getProperty(directory, directory);
        return directory.replaceAll("\\.", "/");
    }

    @Override
    public String filename(IClass clazz) {
        return clazz.getName() + ".py";
    }

    protected boolean isClass(IClass clazz) {
        return true;
    }

    @Override
    public boolean print(File file, IClass clazz) throws IOException {
        Iterator i;
        IndentPrintWriter out = new IndentPrintWriter(new PrintWriter(new BufferedWriter(new FileWriter(file))));
        out.setIndentString("    ");
        this.printEnumFields(file, clazz);
        IMethod[] methods = clazz.getMethods();
        HashSet<String> allNames = new HashSet<String>();
        HashMap<String, IMethod> single = new HashMap<String, IMethod>();
        HashMap<String, ArrayList<IMethod>> overloaded = new HashMap<String, ArrayList<IMethod>>();
        if (methods.length > 0) {
            for (int i2 = 0; i2 < methods.length; ++i2) {
                String name = methods[i2].getName();
                if (allNames.contains(name)) {
                    ArrayList<IMethod> methodList = (ArrayList<IMethod>)overloaded.get(name);
                    if (methodList == null) {
                        methodList = new ArrayList<IMethod>();
                        overloaded.put(name, methodList);
                    }
                    methodList.add(methods[i2]);
                    IMethod first = (IMethod)single.remove(name);
                    if (first == null) continue;
                    methodList.add(first);
                    continue;
                }
                allNames.add(name);
                single.put(name, methods[i2]);
            }
        }
        this.printHeader(out, clazz);
        TreeSet sysImports = new TreeSet();
        TreeSet imports = new TreeSet();
        this.importFromSingle(clazz, single, sysImports, imports);
        this.importFromOverloaded(clazz, overloaded, sysImports, imports);
        if (!sysImports.isEmpty()) {
            out.println();
            i = sysImports.iterator();
            while (i.hasNext()) {
                out.println(i.next());
            }
        }
        if (!imports.isEmpty()) {
            out.println();
            i = imports.iterator();
            while (i.hasNext()) {
                out.println(i.next());
            }
        }
        out.println();
        this.printClassHeader(out, clazz);
        IField[] fields = clazz.getFields();
        if (fields.length > 0) {
            out.println();
        }
        for (int i3 = 0; i3 < fields.length; ++i3) {
            if (i3 != 0) {
                out.println();
            }
            this.printField(out, fields[i3], true);
        }
        if (methods.length > 0) {
            for (String name : single.keySet()) {
                IMethod method = (IMethod)single.get(name);
                this.printMethod(out, clazz, method);
            }
            for (String name : overloaded.keySet()) {
                List methodList = (List)overloaded.get(name);
                int maxNumberOfArguments = 0;
                HashSet<String> overloadedNames = new HashSet<String>();
                for (IMethod method : methodList) {
                    String overloadedName = this.overloadedMethodName(method);
                    if (overloadedNames.contains(overloadedName)) continue;
                    overloadedNames.add(overloadedName);
                    this.printOverloadedMethod(out, clazz, method, overloadedName);
                    maxNumberOfArguments = Math.max(maxNumberOfArguments, method.getParameterTypes().length);
                }
                this.printDispatchMethod(out, clazz, methods, name, maxNumberOfArguments);
            }
        }
        this.printEOCComments(out, clazz);
        this.printEOFComments(out, clazz);
        out.println("# end of class or interface");
        this.printEOFComments(out, clazz);
        out.println();
        out.close();
        return false;
    }

    protected void printEnumFields(File file, IClass clazz) throws IOException {
        IField[] enums = clazz.getEnumFields();
        for (int i = 0; i < enums.length; ++i) {
            String name = enums[i].getNamedType().getType().getName();
            IndentPrintWriter eout = new IndentPrintWriter(new BufferedWriter(new FileWriter(new File(file.getParentFile(), name + ".py"))));
            this.printHeader(eout, clazz);
            eout.println("class " + name + ":");
            this.printField(eout, enums[i], false);
            eout.close();
        }
    }

    protected void printHeader(IndentPrintWriter out, IClass clazz) {
        this.warning(out);
        out.println();
        String[] packageComments = clazz.getPackageComments(language);
        if (packageComments.length > 0) {
            out.println("\"\"\"");
            for (int i = 0; i < packageComments.length; ++i) {
                out.println(packageComments[i]);
            }
            out.println("\"\"\"");
        }
    }

    @Override
    protected void warning(IndentPrintWriter out) {
        out.println("\"\"\" AID-GENERATED");
        out.println("=========================================================================");
        out.println("This class was generated by AID - Abstract Interface Definition          ");
        out.println("DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. ");
        out.println("=========================================================================");
        out.println("\"\"\"");
    }

    protected void importFromOverloaded(IClass clazz, Map overloaded, SortedSet sysImports, SortedSet imports) {
        String[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.importFrom(interfaces[i], clazz, sysImports, imports, true);
        }
        for (String name : overloaded.keySet()) {
            List methodList = (List)overloaded.get(name);
            for (IMethod method : methodList) {
                INamedType[] parameterTypes = method.getParameterTypes();
                for (int p = 0; p < parameterTypes.length; ++p) {
                    this.importFrom(parameterTypes[p].getType(), clazz, sysImports, imports, true);
                    String init = parameterTypes[p].getInit();
                    if (init == null) continue;
                    init = this.valueProperties.getProperty(init, init);
                    this.importFrom(init, clazz, sysImports, imports, false);
                }
            }
        }
        IField[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            IType type = fields[i].getNamedType().getType();
            this.importFrom(type, clazz, sysImports, imports, true);
        }
    }

    protected void importFromSingle(IClass clazz, Map single, SortedSet sysImports, SortedSet imports) {
        for (String name : single.keySet()) {
            IMethod method = (IMethod)single.get(name);
            INamedType[] parameterTypes = method.getParameterTypes();
            for (int p = 0; p < parameterTypes.length; ++p) {
                String init = parameterTypes[p].getInit();
                if (init == null) continue;
                init = this.valueProperties.getProperty(init, init);
                this.importFrom(init, clazz, sysImports, imports, false);
            }
        }
    }

    protected void importFrom(IType type, IClass clazz, SortedSet sysImports, SortedSet imports, boolean report) {
        if (type.isEnumeration()) {
            return;
        }
        this.importFrom(type.getName(), clazz, sysImports, imports, report);
    }

    protected void importFrom(String name, IClass clazz, SortedSet sysImports, SortedSet imports, boolean report) {
        if (name == null) {
            return;
        }
        if (name.equals("[]")) {
            name = "\\[\\]";
        }
        if ((name = this.typeProperties.getProperty(name, name).trim()).equals("")) {
            return;
        }
        String importName = this.importProperties.getProperty(name, null);
        if (importName != null) {
            if (!(importName = importName.trim()).equals(clazz.getPackageName() + "." + clazz.getName())) {
                int dot = importName.lastIndexOf(".");
                if (dot >= 0) {
                    importName = importName.substring(0, dot);
                    importName = this.typeProperties.getProperty(importName, importName).trim() + "." + name;
                    imports.add("from " + importName + " import *");
                } else {
                    sysImports.add("from " + importName + " import " + name);
                }
            }
        } else if (report) {
            System.err.println("Do not know how to import '" + name + "'");
        }
    }

    protected void printClassHeader(IndentPrintWriter out, IClass clazz) {
        int i;
        out.print("class ");
        out.print(clazz.getName());
        String[] classes = clazz.getInterfaces();
        if (classes.length > 0) {
            int k = 0;
            for (i = 0; i < classes.length; ++i) {
                String superclass = this.typeProperties.getProperty(classes[i], classes[i]);
                if (superclass.equals("")) continue;
                if (k == 0) {
                    out.print("(");
                } else {
                    out.print(", ");
                }
                out.print(superclass);
                ++k;
            }
            if (k > 0) {
                out.print(")");
            }
        }
        out.println(": ");
        String[] comments = clazz.getComments(language);
        if (comments.length > 0) {
            out.println("    \"\"\"");
            for (i = 0; i < comments.length; ++i) {
                out.print("    ");
                out.println(comments[i]);
            }
            out.println("    \"\"\"");
            out.println();
        }
    }

    protected void printMethod(IndentPrintWriter out, IClass clazz, IMethod method) {
        this.printMethodHeader(out, clazz, method);
        this.printMethodComments(out, method);
        this.printMethodBody(out, clazz, method);
    }

    protected void printDispatchMethod(IndentPrintWriter out, IClass clazz, IMethod[] methods, String name, int maxNumberOfParameters) {
        out.print("    def ");
        out.print(name);
        out.print("(self");
        for (int i = 1; i <= maxNumberOfParameters; ++i) {
            out.print(", ");
            out.print("arg" + i + " = None");
        }
        out.println("):");
        out.println("        \"\"\"Dispatch method for the '" + name + "' routine.");
        out.println("        This method takes a maximum number of arguments = " + maxNumberOfParameters);
        out.println("        Look at the individual methods with name '" + name + "_...' for documentation.");
        out.println("        @throws TypeError if number of parameters incorrect or types incompatible.");
        out.println("        \"\"\"");
        out.println();
        HashMap<String, String> expressions = new HashMap<String, String>();
        for (int m = 0; m < methods.length; ++m) {
            IMethod method = methods[m];
            if (!method.getName().equals(name)) continue;
            INamedType[] parameterTypes = method.getParameterTypes();
            StringBuffer expression = new StringBuffer();
            for (int i = 0; i < maxNumberOfParameters; ++i) {
                if (i != 0) {
                    expression.append(" and ");
                }
                if (i < parameterTypes.length) {
                    String listType;
                    String type = this.type(parameterTypes[i].getType());
                    String listSubType = null;
                    if (!builtinTypes.contains(type) && type.endsWith(listType = "ListType")) {
                        listSubType = type.substring(0, type.length() - listType.length());
                        type = listType;
                    }
                    expression.append("isinstance(arg" + (i + 1) + ", " + type + ")");
                    if (listSubType == null) continue;
                    expression.append(" and (((len(arg" + (i + 1) + ") > 0) and isinstance(arg" + (i + 1) + "[0], " + listSubType + ")) or (len(arg" + (i + 1) + ") == 0))");
                    continue;
                }
                expression.append("(arg" + (i + 1) + " == None)");
            }
            if (expressions.containsKey(expression.toString())) continue;
            StringBuffer call = new StringBuffer();
            call.append("            self.");
            call.append(this.overloadedMethodName(method));
            call.append("(");
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    call.append(", ");
                }
                call.append("arg" + (i + 1));
            }
            call.append(")");
            expressions.put(expression.toString(), call.toString());
        }
        String expression = null;
        Iterator i = expressions.keySet().iterator();
        while (i.hasNext()) {
            out.print("        ");
            out.print(expression == null ? "if" : "elif");
            out.print(" ");
            expression = (String)i.next();
            out.print(expression);
            out.print(":");
            out.println();
            out.println(expressions.get(expression));
        }
        out.println("        else:");
        out.println("            raise TypeError");
        out.println();
    }

    protected void printOverloadedMethod(IndentPrintWriter out, IClass clazz, IMethod method, String overloadedName) {
        INamedType[] parameterTypes = method.getParameterTypes();
        out.print("    def ");
        out.print(overloadedName);
        out.print("(self");
        for (int i = 0; i < parameterTypes.length; ++i) {
            out.print(", ");
            String name = parameterTypes[i].getName();
            out.print(this.namesProperties.getProperty(name, name));
        }
        out.println("):");
        this.printMethodComments(out, method);
        out.println("        raise NotImplementedError");
        out.println();
    }

    protected void printMethodComments(IndentPrintWriter out, IMethod method) {
        String[] comments = method.getComments(language);
        if (comments.length > 0) {
            out.println("        \"\"\"");
            for (int i = 0; i < comments.length; ++i) {
                comments[i] = this.translate(comments[i], this.typeProperties);
                comments[i] = this.translate(comments[i], this.valueProperties);
                comments[i] = this.translate(comments[i], this.commentProperties);
                out.print("        ");
                out.println(comments[i]);
            }
            out.println("        \"\"\"");
            out.println();
        }
    }

    private String translate(String s, Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            s = s.replaceAll("(^|\\s)" + name + "(\\s|$)", "$1" + p.getProperty(name) + "$2");
        }
        return s;
    }

    protected String overloadedMethodName(IMethod method) {
        StringBuffer s = new StringBuffer();
        s.append(method.getName());
        INamedType[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                s.append("_");
                s.append(this.type(parameterTypes[i].getType()));
            }
        } else {
            s.append("_None");
        }
        return s.toString();
    }

    protected void printMethodHeader(IndentPrintWriter out, IClass clazz, IMethod method) {
        out.print("    def ");
        out.print(method.getName());
        out.print("(self");
        INamedType[] parameterTypes = method.getParameterTypes();
        int noOfParameters = parameterTypes.length;
        for (int i = 0; i < noOfParameters; ++i) {
            out.print(", ");
            String name = parameterTypes[i].getName();
            out.print(this.namesProperties.getProperty(name, name));
            String init = parameterTypes[i].getInit();
            if (init != null) {
                init = this.valueProperties.getProperty(init, init);
            }
            if (init == null || init.equals("")) continue;
            out.print(" = ");
            out.print(init);
        }
        out.println("):");
    }

    protected void printMethodBody(IndentPrintWriter out, IClass clazz, IMethod method) {
        out.println("        raise NotImplementedError");
        out.println();
    }

    protected void printField(IndentPrintWriter out, IField field, boolean prefix) {
        IType type = field.getNamedType().getType();
        String[] comments = field.getComments(language);
        int enumInit = 0;
        boolean enumSet = false;
        StringBuffer initStringBuffer = new StringBuffer();
        out.print("    ");
        while (field != null) {
            INamedType namedType = field.getNamedType();
            String name = namedType.getName();
            name = this.namesProperties.getProperty(name, name);
            if (type.isEnumeration() && prefix && !type.getName().equals("")) {
                out.print(type.getName() + "_");
            }
            out.print(name);
            String init = namedType.getInit();
            if (init != null) {
                init = this.valueProperties.getProperty(init, init);
            }
            if (init != null && !init.equals("")) {
                if (type.isEnumeration()) {
                    int value = Integer.decode(init);
                    initStringBuffer.append(enumInit == 0 ? "[" : ", ");
                    initStringBuffer.append(value);
                    enumInit = value + 1;
                    enumSet = true;
                } else {
                    out.print(" = ");
                    out.print(init);
                }
            } else if (type.isEnumeration()) {
                initStringBuffer.append(enumInit == 0 ? "[" : ", ");
                initStringBuffer.append(enumInit);
                ++enumInit;
            }
            if ((field = field.getNext()) == null) continue;
            out.print(", ");
        }
        if (type.isEnumeration()) {
            if (enumSet) {
                out.println(" = " + initStringBuffer.toString() + "]");
            } else {
                out.println(" = range(" + enumInit + ")");
            }
        }
        if (comments.length > 0) {
            out.println("    \"\"\"");
            for (int i = 0; i < comments.length; ++i) {
                out.print("    ");
                out.println(comments[i]);
            }
            out.println();
            out.println("    \"\"\"");
        }
        out.println();
        out.println();
    }

    protected String type(IType type) {
        return this.type(type, 0);
    }

    private String type(IType type, int nesting) {
        int i;
        IType[] types = type.getTypes();
        StringBuffer s = new StringBuffer();
        String typeName = type.getName();
        if (typeName.equals("[]")) {
            s.append(this.type(types[0]));
        } else {
            typeName = this.typeProperties.getProperty(typeName, typeName);
            s.append(typeName);
            if (types.length > 0) {
                if (!typeName.equals("") && nesting == 0) {
                    s.append("of");
                }
                s.append(this.type(types[0], nesting + 1));
                for (i = 1; i < types.length; ++i) {
                    s.append("and");
                    s.append(this.type(types[i], nesting + 1));
                }
            }
        }
        for (i = 0; i < type.getDimension(); ++i) {
            s.append("ListType");
        }
        return s.toString();
    }

    protected void printEOCComments(IndentPrintWriter out, IClass clazz) {
        String[] eocComments = clazz.getEOCComments(language);
        if (eocComments.length > 0) {
            out.println();
            out.println("    \"\"\"");
            for (int i = 0; i < eocComments.length; ++i) {
                out.print("    ");
                out.println(eocComments[i]);
            }
            out.println("    \"\"\"");
        }
    }

    protected void printEOPComments(IndentPrintWriter out, IClass clazz) {
        String[] eopComments = clazz.getEOPComments(language);
        if (eopComments.length > 0) {
            out.println();
            out.println("    \"\"\"");
            for (int i = 0; i < eopComments.length; ++i) {
                out.print("    ");
                out.println(eopComments[i]);
            }
            out.println("    \"\"\"");
        }
    }

    protected void printEOFComments(IndentPrintWriter out, IClass clazz) {
        String[] eofComments = clazz.getEOFComments(language);
        if (eofComments.length > 0) {
            out.println();
            out.println("\"\"\"");
            for (int i = 0; i < eofComments.length; ++i) {
                out.println(eofComments[i]);
            }
            out.println("\"\"\"");
        }
    }

    static {
        builtinTypes.add("NoneType");
        builtinTypes.add("TypeType");
        builtinTypes.add("BooleanType");
        builtinTypes.add("IntType");
        builtinTypes.add("LongType");
        builtinTypes.add("FloatType");
        builtinTypes.add("ComplexType");
        builtinTypes.add("StringType");
        builtinTypes.add("UnicodeType");
        builtinTypes.add("TupleType");
        builtinTypes.add("ListType");
        builtinTypes.add("DictType");
        builtinTypes.add("DictionaryType");
        builtinTypes.add("FunctionType");
        builtinTypes.add("LambdaType");
        builtinTypes.add("GeneratorType");
        builtinTypes.add("CodeType");
        builtinTypes.add("ClassType");
        builtinTypes.add("InstanceType");
        builtinTypes.add("MethodType");
        builtinTypes.add("UnboundMethodType");
        builtinTypes.add("BuiltinFunctionType");
        builtinTypes.add("BuiltinMethodType");
        builtinTypes.add("ModuleType");
        builtinTypes.add("FileType");
        builtinTypes.add("XRangeType");
        builtinTypes.add("SliceType");
        builtinTypes.add("EllipsisType");
        builtinTypes.add("TracebackType");
        builtinTypes.add("FrameType");
        builtinTypes.add("BufferType");
        builtinTypes.add("StringTypes");
    }
}

