/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import org.freehep.aid.AbstractJavaGenerator;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.IType;
import org.freehep.util.io.IndentPrintWriter;

public class JavaInterfaceGenerator
extends AbstractJavaGenerator {
    public JavaInterfaceGenerator(String propDir) {
        super(propDir);
        this.properties.setProperty("java.interface", "true");
    }

    @Override
    public String filename(IClass clazz) {
        return clazz.getName() + ".java";
    }

    @Override
    protected void printClassHeader(IndentPrintWriter out, IClass clazz) {
        out.println();
        String[] comments = clazz.getComments("java");
        for (int i = 0; i < comments.length; ++i) {
            out.println(comments[i]);
        }
        String[] templateParameters = clazz.getTemplateParameters();
        String[] concrete = this.getConcrete(clazz);
        out.print("public ");
        if (clazz.isClass() || concrete != null) {
            out.print("abstract ");
        }
        out.print(clazz.isClass() ? "class " : "interface ");
        out.print(clazz.getName());
        if (templateParameters.length > 0 && concrete == null) {
            out.print("<");
            out.print(templateParameters[0]);
            for (int i = 1; i < templateParameters.length; ++i) {
                out.print(", ");
                out.print(templateParameters[i]);
            }
            out.print("> ");
        }
        String[] interfaces = clazz.getInterfaces();
        int k = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            String javaInterface = this.typeProperties.getProperty(interfaces[i], interfaces[i]);
            if (javaInterface.equals("")) continue;
            if (k == 0) {
                out.print(clazz.isClass() ? " implements " : " extends ");
            } else {
                out.print(", ");
            }
            out.print(javaInterface);
            ++k;
        }
        out.println(" {");
    }

    @Override
    protected void printEOCComments(IndentPrintWriter out, IClass clazz) {
        String[] eocComments = clazz.getEOCComments("java");
        if (eocComments.length > 0) {
            out.println();
            for (int i = 0; i < eocComments.length; ++i) {
                out.println(eocComments[i]);
            }
        }
    }

    @Override
    protected void printEOPComments(IndentPrintWriter out, IClass clazz) {
        String[] eopComments = clazz.getEOPComments("java");
        if (eopComments.length > 0) {
            out.println();
            for (int i = 0; i < eopComments.length; ++i) {
                out.println(eopComments[i]);
            }
            out.println();
        }
    }

    @Override
    protected void printEOFComments(IndentPrintWriter out, IClass clazz) {
        String[] eofComments = clazz.getEOFComments("java");
        if (eofComments.length > 0) {
            out.println();
            for (int i = 0; i < eofComments.length; ++i) {
                out.println(eofComments[i]);
            }
        }
    }

    @Override
    protected void printMethodComments(IndentPrintWriter out, IMethod method, int noOfParameters) {
        String[] comments = method.getComments("java");
        int param = 0;
        for (int i = 0; i < comments.length; ++i) {
            if (comments[i].indexOf("@param") >= 0) {
                if (param >= noOfParameters) continue;
                ++param;
                out.println(comments[i]);
                continue;
            }
            out.println(comments[i]);
        }
    }

    @Override
    protected void printField(IndentPrintWriter pw, IField field, boolean innerClass) {
        IType type = field.getNamedType().getType();
        String[] comments = field.getComments("java");
        for (int i = 0; i < comments.length; ++i) {
            pw.println(comments[i]);
        }
        if (type.isEnumeration() && !type.getName().equals("")) {
            pw.print("    public ");
            if (innerClass) {
                pw.print("static ");
            }
            pw.println("interface " + type.getName() + " {");
            pw.indent();
        }
        pw.print("    public ");
        if (type.isConst()) {
            pw.print("final static ");
        }
        pw.print(this.type(type, null, innerClass && type.isEnumeration()));
        int enumInit = 0;
        pw.print(" ");
        while (field != null) {
            INamedType namedType = field.getNamedType();
            pw.print(namedType.getName());
            String init = namedType.getInit();
            if (init != null) {
                init = this.valueProperties.getProperty(init, init);
            }
            if (init != null && !init.equals("")) {
                pw.print(" = ");
                pw.print(init);
                if (type.isEnumeration()) {
                    enumInit = Integer.decode(init);
                    ++enumInit;
                }
            } else if (type.isEnumeration()) {
                pw.print(" = ");
                pw.print(enumInit);
                ++enumInit;
            }
            if ((field = field.getNext()) == null) continue;
            pw.print(", ");
        }
        pw.println(";");
        if (type.isEnumeration() && !type.getName().equals("")) {
            pw.outdent();
            pw.println("    } // " + type.getName());
        }
    }
}

