/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.freehep.aid.AbstractCPPGenerator;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IConstructor;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.util.io.IndentPrintWriter;

public abstract class AbstractCPPHeaderGenerator
extends AbstractCPPGenerator {
    public AbstractCPPHeaderGenerator(String propDir) {
        super(propDir);
        this.properties.setProperty("cpp.header", "true");
    }

    @Override
    public String directory(IClass clazz) {
        return "";
    }

    @Override
    protected String prefix() {
        return "";
    }

    protected abstract void printClassHeader(IndentPrintWriter var1, IClass var2);

    protected void printPrivate(IndentPrintWriter out, IClass clazz) {
    }

    protected void printProtected(IndentPrintWriter out, IClass clazz) {
    }

    protected void printPublic(IndentPrintWriter out, IClass clazz) {
    }

    @Override
    public boolean print(File file, IClass clazz) throws IOException {
        String[] eofComments;
        IndentPrintWriter out = new IndentPrintWriter(new PrintWriter(new BufferedWriter(new FileWriter(file))));
        out.setIndentString("    ");
        out.println("// -*- C++ -*-");
        this.warning(out);
        String namespace = this.namespace(clazz);
        if (!namespace.equals("")) {
            namespace = namespace.replaceAll("::", "_") + "_";
        }
        String define = this.prefix() + namespace + this.prefix() + clazz.getName() + "_H";
        define = define.toUpperCase();
        out.println("#ifndef " + define);
        out.println("#define " + define + " 1");
        String[] packageComments = clazz.getPackageComments("cpp");
        if (packageComments.length > 0) {
            out.println();
        }
        for (int i = 0; i < packageComments.length; ++i) {
            out.println(packageComments[i]);
        }
        SortedSet types = this.printIncludeStatements(out, clazz);
        String[] classComments = clazz.getComments("cpp");
        for (int i = 0; i < classComments.length; ++i) {
            if (classComments[i].indexOf("#include") < 0) continue;
            out.println(classComments[i]);
        }
        boolean writeClass = this.printDefines(out, clazz);
        boolean writeNameSpace = clazz.getEnumFields().length > 0;
        String[] namespaces = (this.prefix() + this.namespace(clazz)).split("::");
        if (writeNameSpace || writeClass) {
            int i;
            if (!writeClass) {
                out.println();
                String[] comments = clazz.getComments("cpp");
                for (i = 0; i < comments.length; ++i) {
                    if (comments[i].indexOf("#include") >= 0) continue;
                    out.println(comments[i]);
                }
            }
            for (int i2 = 0; i2 < namespaces.length; ++i2) {
                if (i2 == 0) {
                    out.println();
                }
                out.println("namespace " + namespaces[i2] + " {");
            }
            IField[] enums = clazz.getEnumFields();
            for (i = 0; i < enums.length; ++i) {
                this.printField(out, enums[i], null);
            }
        }
        if (writeClass) {
            int i;
            HashSet<String> templateParameters = new HashSet<String>();
            templateParameters.addAll(Arrays.asList(clazz.getTemplateParameters()));
            IMethod[] methods = clazz.getMethods();
            for (int i3 = 0; i3 < methods.length; ++i3) {
                templateParameters.addAll(Arrays.asList(methods[i3].getTemplateParameters()));
            }
            Iterator it = types.iterator();
            if (it.hasNext()) {
                out.println();
            }
            while (it.hasNext()) {
                String type = (String)it.next();
                if (templateParameters.contains(type)) continue;
                out.println("class " + type + ";");
            }
            out.println();
            String[] comments = clazz.getComments("cpp");
            for (int i4 = 0; i4 < comments.length; ++i4) {
                if (comments[i4].indexOf("#include") >= 0) continue;
                out.println(comments[i4]);
            }
            this.printClassHeader(out, clazz);
            this.printPrivate(out, clazz);
            this.printProtected(out, clazz);
            this.printPublic(out, clazz);
            IConstructor[] constructors = clazz.getConstructors();
            for (i = 0; i < constructors.length; ++i) {
                this.printConstructor(out, constructors[i], this.namespace(clazz));
            }
            for (i = 0; i < methods.length; ++i) {
                this.printMethod(out, methods[i], this.namespace(clazz));
            }
            IField[] fields = clazz.getFields();
            for (int i5 = 0; i5 < fields.length; ++i5) {
                this.printField(out, fields[i5], this.namespace(clazz));
            }
            String[] eocComments = clazz.getEOCComments("cpp");
            if (eocComments.length > 0) {
                out.println();
            }
            for (int i6 = 0; i6 < eocComments.length; ++i6) {
                out.println(eocComments[i6]);
            }
            out.println("}; // class");
            String[] eopComments = clazz.getEOPComments("cpp");
            if (eopComments.length > 0) {
                out.println();
                for (int i7 = 0; i7 < eopComments.length; ++i7) {
                    out.println(eopComments[i7]);
                }
                out.println();
            }
        }
        if (writeNameSpace || writeClass) {
            for (int i = namespaces.length - 1; i >= 0; --i) {
                out.println("} // namespace " + namespaces[i]);
            }
        }
        if ((eofComments = clazz.getEOFComments("cpp")).length > 0) {
            out.println();
            for (int i = 0; i < eofComments.length; ++i) {
                out.println(eofComments[i]);
            }
        }
        out.println("#endif /* ifndef " + define + " */");
        out.close();
        return false;
    }

    protected void printConstructor(IndentPrintWriter out, IConstructor constructor, String nameSpace) {
    }

    protected void printMethod(IndentPrintWriter out, IMethod method, String nameSpace) {
        boolean useExceptions = this.properties.isProperty("useExceptions", true);
        String[] exceptionTypes = method.getExceptionTypes();
        out.println();
        String[] comments = method.getComments("cpp");
        boolean returnWritten = false;
        for (int i = 0; i < comments.length; ++i) {
            int index = comments[i].indexOf("@throws");
            if (index >= 0 && !useExceptions) {
                if (returnWritten || exceptionTypes.length <= 0 || !method.getReturnType().isVoid()) continue;
                int space = index + 7;
                while (Character.isWhitespace(comments[i].charAt(space))) {
                    ++space;
                }
                while (!Character.isWhitespace(comments[i].charAt(space))) {
                    ++space;
                }
                String value = this.valueProperties.getProperty("returnInCaseOfException", "true");
                out.println(comments[i].substring(0, index) + "@return " + value + comments[i].substring(space));
                returnWritten = true;
                continue;
            }
            out.println(comments[i]);
        }
        out.print("    ");
        String[] templateParameters = method.getTemplateParameters();
        if (templateParameters.length > 0) {
            out.print("template <class ");
            out.print(templateParameters[0]);
            for (int i = 1; i < templateParameters.length; ++i) {
                out.print(", class ");
                out.print(templateParameters[i]);
            }
            out.print("> ");
        }
        out.print("virtual ");
        if (exceptionTypes.length > 0 && method.getReturnType().isVoid() && !useExceptions) {
            out.print("AID_EXCEPTION");
        } else {
            out.print(this.converter.type(method.getReturnType(), nameSpace));
        }
        out.print(" ");
        out.print(method.getName());
        out.print("(");
        INamedType[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            out.print(this.namedType(parameterTypes[i], nameSpace));
            if (i >= parameterTypes.length - 1) continue;
            out.print(", ");
        }
        out.print(")");
        if (method.isConst()) {
            out.print(" const");
        }
        if (exceptionTypes.length > 0 && useExceptions) {
            out.print(" throw (");
            for (int e = 0; e < exceptionTypes.length; ++e) {
                if (e != 0) {
                    out.print(", ");
                }
                out.print(this.converter.qualifiedName(exceptionTypes[e], nameSpace));
            }
            out.print(") ");
        }
    }

    protected abstract boolean printDefines(IndentPrintWriter var1, IClass var2);

    protected abstract void printField(IndentPrintWriter var1, IField var2, String var3);
}

