/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.freehep.aid.AbstractGenerator;
import org.freehep.aid.AidUtil;
import org.freehep.aid.CPPTypeConverter;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.IType;
import org.freehep.util.UserProperties;
import org.freehep.util.io.IndentPrintWriter;

public abstract class AbstractCPPGenerator
extends AbstractGenerator {
    protected static final String language = "cpp";
    protected UserProperties typeProperties = new UserProperties();
    protected UserProperties sysIncludeProperties = new UserProperties();
    protected UserProperties includeProperties = new UserProperties();
    protected UserProperties valueProperties = new UserProperties();
    protected UserProperties namesProperties = new UserProperties();
    protected CPPTypeConverter converter;

    public AbstractCPPGenerator(String propDir) {
        AidUtil.loadProperties(this.properties, this.getClass(), propDir, "aid.cpp.properties");
        AidUtil.loadProperties(this.sysIncludeProperties, this.getClass(), propDir, "aid.sysincludes.cpp.properties");
        AidUtil.loadProperties(this.includeProperties, this.getClass(), propDir, "aid.includes.cpp.properties");
        AidUtil.loadProperties(this.valueProperties, this.getClass(), propDir, "aid.values.cpp.properties");
        AidUtil.loadProperties(this.typeProperties, this.getClass(), propDir, "aid.types.cpp.properties");
        AidUtil.loadProperties(this.namesProperties, this.getClass(), propDir, "aid.names.cpp.properties");
        this.converter = new CPPTypeConverter(propDir);
    }

    protected abstract String prefix();

    protected String namespace(IClass clazz) {
        return this.converter.namespace(clazz.getPackageName());
    }

    protected SortedSet printIncludeStatements(IndentPrintWriter out, IClass clazz) {
        String includeName;
        TreeSet sysIncludes = new TreeSet();
        TreeSet includes = new TreeSet();
        TreeSet types = new TreeSet();
        this.includeStatements(clazz, sysIncludes, includes, this.namespace(clazz), types);
        Iterator it = sysIncludes.iterator();
        if (it.hasNext()) {
            out.println();
        }
        while (it.hasNext()) {
            includeName = (String)it.next();
            if (includeName.indexOf("::") >= 0) {
                System.err.println("WARNING: " + clazz.getName() + " does not map '" + includeName + "' to a proper include file...");
            }
            out.println("#include <" + includeName + ">");
        }
        it = includes.iterator();
        if (it.hasNext()) {
            out.println();
        }
        while (it.hasNext()) {
            includeName = (String)it.next();
            if (includeName.indexOf("::") >= 0) {
                System.err.println("WARNING: " + clazz.getName() + " does not map '" + includeName + "' to a proper include file...");
            }
            out.println("#include \"" + includeName + "\"");
        }
        return types;
    }

    protected void includeStatements(IClass clazz, SortedSet sysIncludes, SortedSet includes, String namespace, SortedSet types) {
        IMethod[] methods = clazz.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            this.includeFrom(methods[m].getReturnType(), this.prefix() + clazz.getName(), sysIncludes, includes, namespace, types);
            INamedType[] parameterTypes = methods[m].getParameterTypes();
            for (int p = 0; p < parameterTypes.length; ++p) {
                this.includeFrom(parameterTypes[p].getType(), this.prefix() + clazz.getName(), sysIncludes, includes, namespace, types);
            }
            if (!this.properties.isProperty("useExceptions")) continue;
            String[] exceptionTypes = methods[m].getExceptionTypes();
            for (int e = 0; e < exceptionTypes.length; ++e) {
                this.includeFrom(exceptionTypes[e], this.prefix() + clazz.getName(), sysIncludes, includes, namespace, types);
            }
        }
    }

    protected void includeFrom(IType type, String className, SortedSet sysIncludes, SortedSet includes, String namespace, SortedSet types) {
        if (type.getDimension() > 0) {
            sysIncludes.add("vector");
        }
        if (type.isPrimitive()) {
            return;
        }
        IType[] subTypes = type.getTypes();
        for (int i = 0; i < subTypes.length; ++i) {
            this.includeFrom(subTypes[i], className, sysIncludes, includes, namespace, types);
        }
        if (type.getName().equals("[]")) {
            return;
        }
        this.includeFrom(type.getName(), className, sysIncludes, includes, namespace, types);
    }

    protected void includeFrom(String name, String className, SortedSet sysIncludes, SortedSet includes, String namespace, SortedSet types) {
        if (name == null) {
            return;
        }
        String inc = this.sysIncludeProperties.getProperty(name = this.converter.qualifiedName(name, namespace), null);
        if (inc != null) {
            if (!inc.trim().equals("")) {
                sysIncludes.add(inc);
            }
            return;
        }
        inc = this.includeProperties.getProperty(name, null);
        if (inc != null) {
            if (!inc.trim().equals("")) {
                includes.add(inc);
            }
            return;
        }
        if (!name.equals("") && !name.equals(className)) {
            types.add(name);
        }
    }

    protected String namedType(INamedType namedType, String nameSpace) {
        StringBuffer s = new StringBuffer();
        s.append(this.converter.type(namedType.getType(), nameSpace));
        s.append(" ");
        String name = namedType.getName();
        s.append(this.namesProperties.getProperty(name, name));
        return s.toString();
    }
}

