/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.particle;

import hep.physics.particle.Particle;
import hep.physics.particle.properties.ParticleType;
import hep.physics.vec.Hep3Vector;
import hep.physics.vec.HepLorentzVector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicParticle
implements Particle {
    private Hep3Vector m_origin;
    private HepLorentzVector m_p;
    private double m_productionTime;
    private int m_statusCode;
    private ParticleType m_pType;
    private List parents = Collections.EMPTY_LIST;
    private List daughters = Collections.EMPTY_LIST;
    private double m_mass = Double.NaN;

    public BasicParticle(Hep3Vector origin, HepLorentzVector p, ParticleType ptype, int status, double time) {
        this.m_origin = origin;
        this.m_p = p;
        this.m_pType = ptype;
        this.m_statusCode = status;
        this.m_productionTime = time;
    }

    public void addDaughter(Particle child) {
        if (this.daughters == Collections.EMPTY_LIST) {
            this.daughters = new ArrayList();
        }
        this.daughters.add(child);
        if (child instanceof BasicParticle) {
            ((BasicParticle)child).addParent(this);
        }
    }

    private void addParent(Particle parent) {
        if (this.parents == Collections.EMPTY_LIST) {
            this.parents = new ArrayList();
        }
        this.parents.add(parent);
    }

    public void setMass(double mass) {
        this.m_mass = mass;
    }

    @Override
    public double getPX() {
        return this.m_p.v3().x();
    }

    @Override
    public double getPY() {
        return this.m_p.v3().y();
    }

    @Override
    public double getPZ() {
        return this.m_p.v3().z();
    }

    @Override
    public double getEnergy() {
        return this.m_p.t();
    }

    @Override
    public double getMass() {
        return Double.isNaN(this.m_mass) ? this.m_pType.getMass() : this.m_mass;
    }

    @Override
    public double getOriginX() {
        return this.m_origin.x();
    }

    @Override
    public double getOriginY() {
        return this.m_origin.y();
    }

    @Override
    public double getOriginZ() {
        return this.m_origin.z();
    }

    @Override
    public double getProductionTime() {
        return this.m_productionTime;
    }

    @Override
    public int getGeneratorStatus() {
        return this.m_statusCode;
    }

    @Override
    public Hep3Vector getMomentum() {
        return this.m_p.v3();
    }

    @Override
    public Hep3Vector getOrigin() {
        return this.m_origin;
    }

    @Override
    public List getDaughters() {
        return this.daughters;
    }

    @Override
    public List getParents() {
        return this.parents;
    }

    @Override
    public ParticleType getType() {
        return this.m_pType;
    }

    @Override
    public double getCharge() {
        return this.getType().getCharge();
    }

    @Override
    public int getPDGID() {
        return this.m_pType.getPDGID();
    }

    @Override
    public HepLorentzVector asFourVector() {
        return this.m_p;
    }
}

