/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class XDRRandomAccessFile
extends RandomAccessFile
implements XDRDataInput,
XDRDataOutput {
    private static final int SANITY_CHECK = Integer.getInteger("hep.io.xdr.sanityCheck", 100000);

    public XDRRandomAccessFile(String name, String mode) throws IOException {
        super(name, mode);
    }

    public XDRRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
    }

    @Override
    public void pad() throws IOException {
        long pos = this.getFilePointer();
        int offset = (int)(pos % 4L);
        if (offset != 0) {
            this.seek(pos + 4L - (long)offset);
        }
    }

    @Override
    public double[] readDoubleArray(double[] buffer) throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("Array length failed sanity check: " + l);
        }
        double[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new double[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readDouble();
        }
        return result;
    }

    @Override
    public float[] readFloatArray(float[] buffer) throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("Array length failed sanity check: " + l);
        }
        float[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new float[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readFloat();
        }
        return result;
    }

    @Override
    public int[] readIntArray(int[] buffer) throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("Array length failed sanity check: " + l);
        }
        int[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new int[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    @Override
    public String readString(int l) throws IOException {
        byte[] ascii = new byte[l];
        this.readFully(ascii);
        this.pad();
        return new String(ascii, "US-ASCII");
    }

    @Override
    public String readString() throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("String length failed sanity check: " + l);
        }
        return this.readString(l);
    }

    @Override
    public void writeDoubleArray(double[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeDouble(array[i]);
        }
    }

    @Override
    public void writeDoubleArray(double[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeDouble(array[i]);
        }
    }

    @Override
    public void writeFloatArray(float[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeFloat(array[i]);
        }
    }

    @Override
    public void writeFloatArray(float[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeFloat(array[i]);
        }
    }

    @Override
    public void writeIntArray(int[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeInt(array[i]);
        }
    }

    @Override
    public void writeIntArray(int[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeInt(array[i]);
        }
    }

    @Override
    public void writeString(String s) throws IOException {
        this.writeInt(s.length());
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    @Override
    public void writeStringChars(String s) throws IOException {
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    @Override
    public void flush() throws IOException {
    }
}

