/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRRandomAccessFile;
import java.io.File;
import java.io.IOException;

public class XDRBufferedRandomAccessFile
extends XDRRandomAccessFile {
    private byte[] buffer;
    private long offset;
    private int pos;
    private int used;
    private final boolean readOnly;
    private boolean readMode;

    public XDRBufferedRandomAccessFile(String name, boolean readOnly, int bufferSize) throws IOException {
        super(name, readOnly ? "r" : "rw");
        this.readOnly = readOnly;
        this.readMode = readOnly;
        this.buffer = new byte[bufferSize];
    }

    public XDRBufferedRandomAccessFile(File file, boolean readOnly, int bufferSize) throws IOException {
        super(file, readOnly ? "r" : "rw");
        this.readOnly = readOnly;
        this.readMode = readOnly;
        this.buffer = new byte[bufferSize];
    }

    private void setReadMode(boolean readMode) throws IOException {
        if (this.readMode != readMode) {
            this.flush();
            this.readMode = readMode;
        }
    }

    private void checkCanRead() throws IOException {
        this.setReadMode(true);
    }

    private void checkCanWrite() throws IOException {
        if (this.readOnly) {
            throw new IOException("Can not write to read-only file");
        }
        this.setReadMode(false);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.offset + (long)this.pos;
    }

    @Override
    public void close() throws IOException {
        if (!this.readMode) {
            this.flush();
        }
        super.close();
        this.buffer = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.used > 0) {
            if (this.readMode) {
                this.offset += (long)this.pos;
                super.seek(this.offset);
            } else {
                super.write(this.buffer, 0, this.used);
                this.offset += (long)this.used;
            }
        }
        this.used = 0;
        this.pos = 0;
    }

    private void loadBuffer() throws IOException {
        this.offset += (long)this.used;
        this.used = super.read(this.buffer);
        this.pos = 0;
    }

    @Override
    public int read() throws IOException {
        this.checkCanRead();
        if (this.pos >= this.used) {
            this.loadBuffer();
            if (this.used < 0) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int start, int length) throws IOException {
        this.checkCanRead();
        int available = this.used - this.pos;
        if (available <= 0) {
            this.loadBuffer();
            if (this.used < 0) {
                return -1;
            }
            available = this.used - this.pos;
        }
        int bytesToCopy = Math.min(available, length);
        System.arraycopy(this.buffer, this.pos, buf, start, bytesToCopy);
        this.pos += bytesToCopy;
        return bytesToCopy;
    }

    @Override
    public void seek(long position) throws IOException {
        if (position >= this.offset && position <= this.offset + (long)this.used) {
            this.pos = (int)(position - this.offset);
        } else if (this.readMode) {
            super.seek(position);
            this.offset = position;
            this.used = 0;
            this.pos = 0;
        } else {
            this.flush();
            this.offset = position;
            super.seek(this.offset);
        }
    }

    @Override
    public void write(byte[] buf, int start, int len) throws IOException {
        this.checkCanWrite();
        if (this.buffer.length - this.pos <= len) {
            System.arraycopy(buf, start, this.buffer, this.pos, len);
            this.pos += len;
            if (this.pos > this.used) {
                this.used = this.pos;
            }
        } else {
            this.used = this.pos;
            this.flush();
            super.write(buf, start, len);
            this.offset += (long)len;
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkCanWrite();
        if (this.pos == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)b;
        if (this.pos > this.used) {
            this.used = this.pos;
        }
    }
}

