/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;

class EventTable
extends MCFIOBlock
implements MCFIOConstants {
    private int[] evtnums;
    private int[] ptrEvents;
    private int[] runnums;
    private int[] storenums;
    private int[] trigMasks;
    private int location;
    private int nextLocator;
    private int numevts;

    EventTable() throws IOException {
        super(2);
    }

    EventTable(int pos) throws IOException {
        super(2);
        this.version = "1.00";
        this.location = pos;
        this.nextLocator = -2;
        this.numevts = 0;
        this.runnums = new int[100];
        this.evtnums = new int[100];
        this.storenums = new int[100];
        this.trigMasks = new int[100];
        this.ptrEvents = new int[100];
    }

    @Override
    public void read(XDRDataInput xdr) throws IOException {
        super.read(xdr);
        if (!this.version.equals("1.00")) {
            throw new MCFIOException("Unsupported version " + this.version + " for EventTable");
        }
        this.nextLocator = xdr.readInt();
        this.numevts = xdr.readInt();
        this.evtnums = xdr.readIntArray(this.evtnums);
        this.storenums = xdr.readIntArray(this.storenums);
        this.runnums = xdr.readIntArray(this.runnums);
        this.trigMasks = xdr.readIntArray(this.trigMasks);
        this.ptrEvents = xdr.readIntArray(this.ptrEvents);
    }

    @Override
    public void write(XDRDataOutput xdr) throws IOException {
        super.write(xdr);
        xdr.writeInt(this.nextLocator);
        xdr.writeInt(this.numevts);
        xdr.writeIntArray(this.evtnums);
        xdr.writeIntArray(this.storenums);
        xdr.writeIntArray(this.runnums);
        xdr.writeIntArray(this.trigMasks);
        xdr.writeIntArray(this.ptrEvents);
    }

    @Override
    protected int getLength() {
        return 4 * (11 + this.evtnums.length * 5);
    }

    boolean isFull() {
        return this.numevts >= this.evtnums.length;
    }

    void setNextTable(int pos) {
        this.nextLocator = pos;
    }

    void add(MCFIOEvent event, int pos) throws IOException {
        this.runnums[this.numevts] = event.getRunNumber();
        this.evtnums[this.numevts] = event.getEventNumber();
        this.storenums[this.numevts] = event.getStoreNumber();
        this.trigMasks[this.numevts] = event.getTrigMask();
        this.ptrEvents[this.numevts] = pos;
        ++this.numevts;
    }

    void commit(XDRRandomAccessFile xdr) throws IOException {
        long pos = xdr.getFilePointer();
        xdr.seek(this.location);
        this.write(xdr);
        xdr.seek(pos);
    }

    int evtnum(int index) {
        return this.evtnums[index];
    }

    int nextTable() {
        return this.nextLocator;
    }

    int numevts() {
        return this.numevts;
    }

    int ptrEvent(int index) {
        return this.ptrEvents[index];
    }

    int runnum(int index) {
        return this.runnums[index];
    }

    int storenum(int index) {
        return this.storenums[index];
    }

    int trigMask(int index) {
        return this.trigMasks[index];
    }
}

