/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep1.xml;

import hep.graphics.heprep1.HepRep;
import hep.graphics.heprep1.HepRepReader;
import hep.graphics.heprep1.ref.DefaultHepRep;
import hep.graphics.heprep1.ref.DefaultHepRepAttribute;
import hep.graphics.heprep1.ref.DefaultHepRepInstance;
import hep.graphics.heprep1.ref.DefaultHepRepPoint;
import hep.graphics.heprep1.ref.DefaultHepRepPrimitive;
import hep.graphics.heprep1.ref.DefaultHepRepType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractSequentialList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.freehep.util.io.NoCloseInputStream;
import org.freehep.util.io.XMLSequence;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHepRepReader
implements HepRepReader {
    protected InputStream input;
    protected String name;
    private ZipEntry entry;
    private ZipInputStream zip;
    protected ZipFile zipFile;
    private Enumeration zipEntries;
    private int position;
    private XMLSequence sequence;

    public XMLHepRepReader(InputStream input) throws IOException {
        this.input = input;
        this.reset();
    }

    public XMLHepRepReader(String name) throws IOException {
        this.name = name;
        this.reset();
    }

    protected HepRep readHepRep(InputStream stream) throws IOException {
        DefaultHepRep heprep = new DefaultHepRep();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            Handler handler = new Handler(heprep);
            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            reader.setErrorHandler(handler);
            reader.setEntityResolver(handler);
            String attributesFile = "AttributeDefaults.xml";
            InputStream attributes = this.getClass().getResourceAsStream(attributesFile);
            if (attributes == null) {
                throw new IOException(this.getClass() + ": Could not find " + attributesFile);
            }
            InputSource ds = new InputSource(attributes);
            reader.parse(ds);
            InputSource is = new InputSource(stream);
            reader.parse(is);
        }
        catch (ParserConfigurationException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        catch (SAXParseException e) {
            IOException exception = new IOException();
            exception.initCause(new SAXParseException(e.getMessage(), e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber()){

                @Override
                public String getMessage() {
                    return "line " + this.getLineNumber() + " column " + this.getColumnNumber() + ": " + super.getMessage();
                }
            });
            throw exception;
        }
        catch (SAXException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        return heprep;
    }

    @Override
    public void close() throws IOException {
        if (this.zip != null) {
            this.zip.close();
        }
        if (this.zipFile != null) {
            this.zipFile.close();
        }
        if (this.sequence != null) {
            this.sequence.close();
        }
    }

    @Override
    public boolean hasSequentialAccess() throws IOException {
        return true;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        if (this.input != null && !(this.input instanceof ZipInputStream)) {
            this.sequence = new XMLSequence(new BufferedInputStream(this.input));
        } else if (this.name != null && !this.name.toLowerCase().endsWith(".zip")) {
            if (this.sequence != null) {
                this.sequence.close();
            }
            this.sequence = this.name.toLowerCase().endsWith(".gz") ? new XMLSequence(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.name)))) : new XMLSequence(new BufferedInputStream(new FileInputStream(this.name)));
        } else if (this.input instanceof ZipInputStream) {
            this.zip = (ZipInputStream)this.input;
            this.zip.reset();
        } else if (this.name != null && this.name.toLowerCase().endsWith(".zip")) {
            this.zipFile = new ZipFile(this.name);
            this.zipEntries = this.zipFile.entries();
            this.position = 0;
        }
    }

    @Override
    public int size() {
        if (this.zipFile != null) {
            return this.zipFile.size();
        }
        return -1;
    }

    @Override
    public int skip(int n) throws UnsupportedOperationException {
        int i;
        try {
            for (i = n; i > 0 && this.hasNext(); --i) {
                this.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n - i;
    }

    @Override
    public boolean hasNext() throws IOException, UnsupportedOperationException {
        if (this.sequence != null) {
            return this.sequence.hasNext();
        }
        if (this.zipFile != null) {
            return this.size() - this.position > 0;
        }
        return true;
    }

    @Override
    public HepRep next() throws IOException, UnsupportedOperationException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException(this.getClass() + " no more elements");
        }
        if (this.sequence != null) {
            return this.readHepRep(this.sequence.next());
        }
        if (this.zip != null) {
            this.entry = this.zip.getNextEntry();
            BufferedInputStream stream = new BufferedInputStream(new NoCloseInputStream(this.zip));
            return this.readHepRep(stream);
        }
        if (this.zipFile != null) {
            this.entry = (ZipEntry)this.zipEntries.nextElement();
            ++this.position;
            InputStream stream = this.zipFile.getInputStream(this.entry);
            if (this.entry.getName().toLowerCase().endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            }
            stream = new BufferedInputStream(stream);
            HepRep heprep = this.readHepRep(stream);
            return heprep;
        }
        return null;
    }

    @Override
    public boolean hasRandomAccess() {
        return this.zipFile != null;
    }

    @Override
    public HepRep read(String name) throws IOException, UnsupportedOperationException, NoSuchElementException {
        if (!this.hasRandomAccess()) {
            throw new UnsupportedOperationException(this.getClass() + " does not support random access");
        }
        this.entry = this.zipFile.getEntry(name);
        if (this.entry == null) {
            throw new NoSuchElementException(this.getClass() + " cannot access entry '" + name + "'");
        }
        BufferedInputStream stream = new BufferedInputStream(this.zipFile.getInputStream(this.entry));
        return this.readHepRep(stream);
    }

    @Override
    public String entryName() {
        return this.entry != null ? this.entry.getName() : null;
    }

    @Override
    public List entryNames() {
        if (this.zipFile == null) {
            return null;
        }
        AbstractSequentialList list = new AbstractSequentialList(){

            @Override
            public int size() {
                return XMLHepRepReader.this.size();
            }

            @Override
            public ListIterator listIterator(int index) {
                final int startIndex = index;
                return new ListIterator(){
                    private int position;
                    private Enumeration entries;
                    private ZipEntry entry;
                    {
                        this.entries = XMLHepRepReader.this.zipFile.entries();
                        this.position = startIndex;
                        for (int i = 0; i <= this.position; ++i) {
                            ZipEntry zipEntry = this.entry = this.entries.hasMoreElements() ? (ZipEntry)this.entries.nextElement() : null;
                            if (this.entry == null) break;
                        }
                        if (this.entry == null) {
                            this.position = this.size();
                        }
                    }

                    public void add(Object o) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entry != null;
                    }

                    @Override
                    public boolean hasPrevious() {
                        return false;
                    }

                    @Override
                    public Object next() {
                        if (this.entry == null) {
                            throw new NoSuchElementException();
                        }
                        return this.entry.getName();
                    }

                    @Override
                    public int nextIndex() {
                        return this.position;
                    }

                    public Object previous() {
                        throw new NoSuchElementException();
                    }

                    @Override
                    public int previousIndex() {
                        return this.position - 1;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    public void set(Object o) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        return list;
    }

    class Handler
    extends DefaultHandler {
        private Hashtable labelTable = new Hashtable(4);
        private HepRep heprep;
        private Stack stack;
        private DefaultHepRepAttribute parent;

        public Handler(HepRep heprep) {
            this.labelTable.put("NONE", new Integer(0));
            this.stack = new Stack();
            this.parent = null;
            this.heprep = heprep;
        }

        @Override
        public void startDocument() throws SAXException {
            this.stack = new Stack();
            this.parent = (DefaultHepRepAttribute)((Object)this.heprep);
        }

        @Override
        public void startElement(String namespace, String tag, String qName, Attributes atts) throws SAXException {
            if (tag.equals("point")) {
                double x = Double.valueOf(atts.getValue("x"));
                double y = Double.valueOf(atts.getValue("y"));
                double z = Double.valueOf(atts.getValue("z"));
                DefaultHepRepPoint node = new DefaultHepRepPoint(this.parent, x, y, z);
                this.stack.push(this.parent);
                this.parent = node;
            } else if (tag.equals("primitive")) {
                DefaultHepRepPrimitive node = new DefaultHepRepPrimitive(this.parent);
                this.stack.push(this.parent);
                this.parent = node;
            } else if (tag.equals("instance")) {
                DefaultHepRepInstance node = new DefaultHepRepInstance(this.parent);
                this.stack.push(this.parent);
                this.parent = node;
            } else if (tag.equals("type")) {
                String name = atts.getValue("name");
                String version = atts.getValue("version");
                DefaultHepRepType node = new DefaultHepRepType(this.parent, name, version);
                this.stack.push(this.parent);
                this.parent = node;
            } else if (!tag.equals("heprep")) {
                if (tag.equals("attvalue")) {
                    String name = atts.getValue("name");
                    String value = atts.getValue("value");
                    String labelString = atts.getValue("showLabel");
                    int showLabel = 0;
                    if (labelString != null) {
                        StringTokenizer st = new StringTokenizer(labelString, ", ");
                        while (st.hasMoreTokens()) {
                            String label = st.nextToken();
                            Integer number = (Integer)this.labelTable.get(label);
                            if (number != null) {
                                showLabel += number.intValue();
                                continue;
                            }
                            showLabel += Integer.parseInt(label);
                        }
                    }
                    this.parent.addValue(name, value, showLabel);
                } else if (tag.equals("attdef")) {
                    String name = atts.getValue("name");
                    String desc = atts.getValue("desc");
                    String type = atts.getValue("type");
                    String extra = atts.getValue("extra");
                    this.parent.addDefinition(name, desc, type, extra);
                } else {
                    throw new SAXException("[XMLHepRepReader] Unknown tag: " + tag);
                }
            }
        }

        @Override
        public void endElement(String namespace, String tag, String qName) throws SAXException {
            if (tag.lastIndexOf(58) >= 0) {
                tag = tag.substring(tag.lastIndexOf(58) + 1);
            }
            if (tag.equals("point")) {
                this.parent = (DefaultHepRepAttribute)this.stack.pop();
            } else if (tag.equals("primitive")) {
                this.parent = (DefaultHepRepAttribute)this.stack.pop();
            } else if (tag.equals("instance")) {
                this.parent = (DefaultHepRepAttribute)this.stack.pop();
            } else if (tag.equals("type")) {
                this.parent = (DefaultHepRepAttribute)this.stack.pop();
            } else if (!(tag.equals("heprep") || tag.equals("attvalue") || tag.equals("attdef"))) {
                throw new SAXException("[XMLHepRepReader] Unknown tag: " + tag);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            InputStream is;
            block4: {
                System.out.println("Resolving: " + systemId);
                if (publicId != null) {
                    return null;
                }
                is = null;
                URL url = null;
                try {
                    url = new URL(systemId);
                    is = url.openStream();
                }
                catch (MalformedURLException mfue) {
                    return null;
                }
                catch (IOException ioe) {
                    String file = url.getFile().substring(url.getFile().lastIndexOf(47) + 1);
                    is = XMLHepRepReader.this.getClass().getResourceAsStream(file);
                    if (is != null) break block4;
                    is = XMLHepRepReader.class.getResourceAsStream(file);
                }
            }
            return new InputSource(is);
        }
    }
}

